/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.io.buffer;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.io.buffer.ReadBuffer;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.function.Function;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Internal
final class NioReadBuffer
extends ReadBuffer {
    private final ByteBuffer buffer;
    private boolean closed;

    NioReadBuffer(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    private void checkOpen() {
        if (this.closed) {
            throw new IllegalStateException("Buffer already closed or consumed");
        }
    }

    @Override
    public int readable() {
        this.checkOpen();
        return this.buffer.remaining();
    }

    @Override
    public @NonNull ReadBuffer duplicate() {
        this.checkOpen();
        return new NioReadBuffer(this.buffer.duplicate());
    }

    @Override
    public @NonNull ReadBuffer split(int splitPosition) {
        this.checkOpen();
        if (splitPosition > this.buffer.remaining()) {
            throw new IndexOutOfBoundsException();
        }
        ByteBuffer slice = this.buffer.slice(this.buffer.position(), splitPosition);
        this.buffer.position(this.buffer.position() + splitPosition);
        return new NioReadBuffer(slice);
    }

    @Override
    public ReadBuffer move() {
        this.checkOpen();
        this.closed = true;
        return new NioReadBuffer(this.buffer);
    }

    @Override
    public void toArray(byte @NonNull [] destination, int offset) {
        this.checkOpen();
        this.closed = true;
        if (offset > destination.length || destination.length - offset < this.buffer.remaining()) {
            throw new IndexOutOfBoundsException();
        }
        this.buffer.get(destination, offset, this.buffer.remaining());
    }

    @Override
    public byte @NonNull [] toArray() {
        this.checkOpen();
        if (this.buffer.hasArray() && this.buffer.arrayOffset() == 0 && this.buffer.position() == 0 && this.buffer.remaining() == this.buffer.array().length) {
            this.closed = true;
            return this.buffer.array();
        }
        return super.toArray();
    }

    @Override
    public InputStream toInputStream() {
        this.checkOpen();
        if (this.buffer.hasArray()) {
            this.closed = true;
            return new ByteArrayInputStream(this.buffer.array(), this.buffer.arrayOffset() + this.buffer.position(), this.buffer.remaining());
        }
        return super.toInputStream();
    }

    @Override
    public <R> @Nullable R useFastHeapBuffer(@NonNull Function<ByteBuffer, @NonNull R> function) {
        this.checkOpen();
        if (this.buffer.hasArray()) {
            this.closed = true;
            return function.apply(this.buffer);
        }
        return super.useFastHeapBuffer(function);
    }

    @Override
    public void close() {
        this.closed = true;
    }

    @Override
    protected boolean isConsumed() {
        return this.closed;
    }

    @Override
    protected byte[] peekArray(int n) {
        byte[] bytes = new byte[n];
        this.buffer.get(this.buffer.position(), bytes, 0, n);
        return bytes;
    }
}

