/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.io;

import io.micronaut.core.annotation.Blocking;
import io.micronaut.core.util.IOExceptionBiFunction;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IOUtils {
    private static final int BUFFER_MAX = 8192;
    private static final String SCHEME_FILE = "file";
    private static final String SCHEME_JAR = "jar";
    private static final String SCHEME_ZIP = "zip";
    private static final String SCHEME_WSJAR = "wsjar";
    private static final String COLON = ":";

    @Blocking
    public static void eachFile(@NonNull URL url, String path, @NonNull Consumer<Path> consumer) {
        try {
            IOUtils.eachFile(url.toURI(), path, consumer);
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Blocking
    public static void eachFile(@NonNull URI uri, String path, final @NonNull Consumer<Path> consumer) {
        ArrayList<Closeable> toClose = new ArrayList<Closeable>();
        try {
            final Path myPath = IOUtils.resolvePath(uri, path, toClose, IOUtils::loadNestedJarUri);
            if (myPath != null) {
                Files.walkFileTree(myPath, Collections.emptySet(), 1, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                    @Override
                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFile(Path currentPath, BasicFileAttributes attrs) throws IOException {
                        if (currentPath.equals(myPath) || Files.isHidden(currentPath) || currentPath.getFileName().startsWith(".")) {
                            return FileVisitResult.CONTINUE;
                        }
                        consumer.accept(currentPath);
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFileFailed(Path file, IOException exc) {
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
        }
        catch (IOException iOException) {
            for (Closeable closeable : toClose) {
                try {
                    closeable.close();
                }
                catch (IOException iOException2) {}
            }
        }
        finally {
            for (Closeable closeable : toClose) {
                try {
                    closeable.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static @Nullable Path resolvePath(@NonNull URI uri, @NonNull String path, @NonNull List<Closeable> toClose) throws IOException {
        return IOUtils.resolvePath(uri, path, toClose, IOUtils::loadNestedJarUri);
    }

    static @Nullable Path resolvePath(@NonNull URI uri, String path, List<Closeable> toClose, IOExceptionBiFunction<List<Closeable>, String, Path> loadNestedJarUriFunction) throws IOException {
        String scheme = uri.getScheme();
        try {
            if (SCHEME_JAR.equals(scheme) || SCHEME_ZIP.equals(scheme) || SCHEME_WSJAR.equals(scheme)) {
                Object jarUri = uri.getRawSchemeSpecificPart();
                int sep = ((String)jarUri).lastIndexOf("!/");
                if (sep != -1) {
                    jarUri = ((String)jarUri).substring(0, sep);
                }
                if (!((String)jarUri).startsWith("file:")) {
                    jarUri = ((String)jarUri).startsWith("/") ? "file:" + (String)jarUri : "file:/" + (String)jarUri;
                }
                jarUri = (String)jarUri + "!/";
                return loadNestedJarUriFunction.apply(toClose, (String)jarUri).resolve(path);
            }
            if (SCHEME_FILE.equals(scheme)) {
                return Paths.get(uri).resolve(path);
            }
            if ("jrt".equals(scheme)) {
                FileSystem fs = FileSystems.newFileSystem(URI.create("jrt:/"), Map.of());
                return fs.getPath(uri.getPath(), new String[0]);
            }
            return Paths.get(uri);
        }
        catch (FileSystemNotFoundException e) {
            return null;
        }
    }

    private static Path loadNestedJarUri(List<Closeable> toClose, String jarUri) throws IOException {
        int sep = jarUri.lastIndexOf("!/");
        if (sep == -1) {
            return Paths.get(URI.create(jarUri));
        }
        Path jarPath = IOUtils.loadNestedJarUri(toClose, jarUri.substring(0, sep));
        if (Files.isDirectory(jarPath, new LinkOption[0])) {
            return jarPath;
        }
        FileSystem zipfs = FileSystems.newFileSystem(jarPath, (ClassLoader)null);
        toClose.add(0, zipfs);
        return zipfs.getPath(jarUri.substring(sep + 1), new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Blocking
    public static String readText(BufferedReader reader) throws IOException {
        StringBuilder answer = new StringBuilder();
        if (reader == null) {
            return answer.toString();
        }
        char[] charBuffer = new char[8192];
        try {
            int nbCharRead;
            while ((nbCharRead = reader.read(charBuffer)) != -1) {
                answer.append(charBuffer, 0, nbCharRead);
            }
            BufferedReader temp = reader;
            reader = null;
            ((Reader)temp).close();
        }
        finally {
            block11: {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException e) {
                    Logger logger = LoggerFactory.getLogger(Logger.class);
                    if (!logger.isWarnEnabled()) break block11;
                    logger.warn("Failed to close reader: {}", (Object)e.getMessage(), (Object)e);
                }
            }
        }
        return answer.toString();
    }

    public static List<URI> getResources(ClassLoader classLoader, String path) throws IOException {
        FileSystem jrtProvider;
        Enumeration<URL> micronautResources = classLoader.getResources(path);
        LinkedHashSet<URI> uniqueURIs = new LinkedHashSet<URI>();
        while (micronautResources.hasMoreElements()) {
            URL url = micronautResources.nextElement();
            try {
                uniqueURIs.add(url.toURI());
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        if (uniqueURIs.isEmpty() && (jrtProvider = IOUtils.getJrtProvider(classLoader)) != null) {
            Path modulesPath = jrtProvider.getPath("modules", new String[0]);
            try (Stream<Path> stream2 = Files.list(modulesPath);){
                stream2.filter(p -> !p.getFileName().toString().startsWith("jdk.")).filter(p -> !p.getFileName().toString().startsWith("java.")).map(p -> p.resolve(path)).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).map(modulesPath::resolve).map(Path::toUri).forEach(uniqueURIs::add);
            }
            try {
                jrtProvider.close();
            }
            catch (Throwable stream2) {
                // empty catch block
            }
        }
        ArrayList<URI> uris = new ArrayList<URI>(uniqueURIs.size());
        for (URI uri : uniqueURIs) {
            String scheme = uri.getScheme();
            if (SCHEME_FILE.equals(scheme)) {
                uri = IOUtils.normalizeFilePath(path, uri);
            }
            if ("resource".equals(scheme) && uri.toString().contains("#")) continue;
            uris.add(uri);
        }
        return uris;
    }

    private static @Nullable FileSystem getJrtProvider(ClassLoader classLoader) {
        try {
            URI uri = URI.create("jrt:/");
            FileSystem fs = FileSystems.getFileSystem(uri);
            if (fs.isOpen()) {
                return fs;
            }
            fs = FileSystems.newFileSystem(uri, Collections.emptyMap(), classLoader);
            if (fs.isOpen()) {
                return fs;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private static URI normalizeFilePath(String path, URI uri) {
        Path p = Paths.get(uri);
        if (p.endsWith(path)) {
            Path subpath = Paths.get(path, new String[0]);
            for (int i = 0; i < subpath.getNameCount(); ++i) {
                p = p.getParent();
            }
            uri = p.toUri();
        }
        return uri;
    }
}

