/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.execution;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.execution.ExecutionFlow;
import io.micronaut.core.execution.ImperativeExecutionFlow;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;

@Internal
final class ImperativeExecutionFlowImpl
implements ImperativeExecutionFlow<Object> {
    private @Nullable Object value;
    private @Nullable Throwable error;
    private @Nullable Map<String, Object> context;

    <T> ImperativeExecutionFlowImpl(T value, Throwable error) {
        this.value = value;
        this.error = error;
    }

    @Override
    public @Nullable Object getValue() {
        return this.value;
    }

    @Override
    public @Nullable Throwable getError() {
        return this.error;
    }

    @Override
    public Map<String, Object> getContext() {
        return this.context == null ? Collections.emptyMap() : this.context;
    }

    @Override
    public <R> ExecutionFlow<R> flatMap(Function<? super Object, ? extends ExecutionFlow<? extends R>> transformer) {
        if (this.error == null) {
            try {
                if (this.value != null) {
                    return transformer.apply(this.value);
                }
            }
            catch (Throwable e) {
                this.error = e;
                this.value = null;
            }
        }
        return this;
    }

    @Override
    public <R> ExecutionFlow<R> then(Supplier<? extends ExecutionFlow<? extends R>> supplier) {
        if (this.error == null) {
            try {
                return supplier.get();
            }
            catch (Throwable e) {
                this.error = e;
                this.value = null;
            }
        }
        return this;
    }

    @Override
    public <R> ExecutionFlow<R> map(Function<? super Object, ? extends R> transformer) {
        if (this.error == null) {
            try {
                this.value = transformer.apply(this.value);
            }
            catch (Throwable e) {
                this.error = e;
                this.value = null;
            }
        }
        return this;
    }

    @Override
    public ExecutionFlow<Object> onErrorResume(Function<? super Throwable, ? extends ExecutionFlow<? extends Object>> fallback) {
        if (this.error != null) {
            try {
                return fallback.apply(this.error);
            }
            catch (Throwable e) {
                this.error = e;
                this.value = null;
            }
        }
        return this;
    }

    @Override
    public ExecutionFlow<Object> putInContext(String key, Object value) {
        if (this.context == null) {
            this.context = new LinkedHashMap<String, Object>();
        }
        this.context.put(key, value);
        return this;
    }

    @Override
    public void onComplete(BiConsumer<? super Object, Throwable> fn) {
        fn.accept(this.value, this.error);
    }

    @Override
    public void completeTo(CompletableFuture<Object> completableFuture) {
        if (this.error != null) {
            completableFuture.completeExceptionally(this.error);
        } else {
            completableFuture.complete(this.value);
        }
    }

    @Override
    public CompletableFuture<Object> toCompletableFuture() {
        if (this.error != null) {
            return CompletableFuture.failedFuture(this.error);
        }
        return CompletableFuture.completedFuture(this.value);
    }
}

