/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.execution;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.execution.DelayedExecutionFlow;
import io.micronaut.core.execution.ImperativeExecutionFlow;
import io.micronaut.core.execution.ImperativeExecutionFlowImpl;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Internal
public interface ExecutionFlow<T> {
    public static <K> @NonNull ExecutionFlow<K> just(@Nullable K value) {
        return new ImperativeExecutionFlowImpl(value, null);
    }

    public static <K> @NonNull ExecutionFlow<K> error(@NonNull Throwable e) {
        return new ImperativeExecutionFlowImpl(null, e);
    }

    public static <T> @NonNull ExecutionFlow<T> empty() {
        return new ImperativeExecutionFlowImpl(null, null);
    }

    public static <T> @NonNull ExecutionFlow<T> async(@NonNull Executor executor, @NonNull Supplier<? extends ExecutionFlow<T>> supplier) {
        DelayedExecutionFlow completableFuture = DelayedExecutionFlow.create();
        executor.execute(() -> ((ExecutionFlow)supplier.get()).onComplete(completableFuture::complete));
        return completableFuture;
    }

    public <R> @NonNull ExecutionFlow<R> map(@NonNull Function<? super T, ? extends R> var1);

    public <R> @NonNull ExecutionFlow<R> flatMap(@NonNull Function<? super T, ? extends ExecutionFlow<? extends R>> var1);

    public <R> @NonNull ExecutionFlow<R> then(@NonNull Supplier<? extends ExecutionFlow<? extends R>> var1);

    public @NonNull ExecutionFlow<T> onErrorResume(@NonNull Function<? super Throwable, ? extends ExecutionFlow<? extends T>> var1);

    public @NonNull ExecutionFlow<T> putInContext(@NonNull String var1, @NonNull Object var2);

    default public @NonNull ExecutionFlow<T> putInContextIfAbsent(@NonNull String key, @NonNull Object value) {
        return this;
    }

    public void onComplete(@NonNull BiConsumer<? super T, Throwable> var1);

    public void completeTo(@NonNull CompletableFuture<T> var1);

    default public @NonNull ExecutionFlow<T> timeout(@NonNull Duration timeout, @NonNull ScheduledExecutorService scheduler, @Nullable BiConsumer<T, Throwable> onDiscard) {
        DelayedExecutionFlow delayed = DelayedExecutionFlow.create();
        AtomicBoolean completed = new AtomicBoolean(false);
        ScheduledFuture<?> future = scheduler.schedule(() -> {
            if (completed.compareAndSet(false, true)) {
                this.cancel();
                delayed.completeExceptionally(new TimeoutException());
            }
        }, timeout.toNanos(), TimeUnit.NANOSECONDS);
        this.onComplete((t, throwable) -> {
            if (completed.compareAndSet(false, true)) {
                future.cancel(false);
                if (throwable != null) {
                    delayed.completeExceptionally((Throwable)throwable);
                } else {
                    delayed.complete(t);
                }
            } else if (onDiscard != null) {
                onDiscard.accept((Object)t, (Throwable)throwable);
            }
        });
        delayed.onCancel(this::cancel);
        return delayed;
    }

    public @Nullable ImperativeExecutionFlow<T> tryComplete();

    default public @Nullable T tryCompleteValue() {
        ImperativeExecutionFlow<T> imperativeFlow = this.tryComplete();
        if (imperativeFlow != null) {
            return imperativeFlow.getValue();
        }
        return null;
    }

    default public @Nullable Throwable tryCompleteError() {
        ImperativeExecutionFlow<T> imperativeFlow = this.tryComplete();
        if (imperativeFlow != null) {
            return imperativeFlow.getError();
        }
        return null;
    }

    default public @NonNull CompletableFuture<T> toCompletableFuture() {
        CompletableFuture completableFuture = new CompletableFuture();
        this.completeTo(completableFuture);
        return completableFuture;
    }

    default public void cancel() {
    }
}

