/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.beans;

import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.beans.BeanIntrospectionReference;
import io.micronaut.core.beans.BeanIntrospector;
import io.micronaut.core.beans.exceptions.IntrospectionException;
import io.micronaut.core.io.service.SoftServiceLoader;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.util.ArgumentUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jspecify.annotations.NonNull;
import org.slf4j.Logger;

class DefaultBeanIntrospector
implements BeanIntrospector {
    private static final Logger LOG = ClassUtils.getLogger(DefaultBeanIntrospector.class);
    private Map<String, BeanIntrospectionReference<Object>> introspectionMap;
    private final ClassLoader classLoader;

    DefaultBeanIntrospector() {
        this.classLoader = DefaultBeanIntrospector.class.getClassLoader();
    }

    DefaultBeanIntrospector(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public @NonNull Collection<BeanIntrospection<Object>> findIntrospections(@NonNull Predicate<? super BeanIntrospectionReference<?>> filter) {
        ArgumentUtils.requireNonNull("filter", filter);
        return this.getIntrospections().values().stream().filter(filter).map(BeanIntrospectionReference::load).collect(Collectors.toList());
    }

    @Override
    public @NonNull Collection<Class<?>> findIntrospectedTypes(@NonNull Predicate<? super BeanIntrospectionReference<?>> filter) {
        ArgumentUtils.requireNonNull("filter", filter);
        return this.getIntrospections().values().stream().filter(filter).map(BeanIntrospectionReference::getBeanType).collect(Collectors.toSet());
    }

    @Override
    public <T> @NonNull Optional<BeanIntrospection<T>> findIntrospection(@NonNull Class<T> beanType) {
        ArgumentUtils.requireNonNull("beanType", beanType);
        BeanIntrospectionReference<Object> reference = this.getIntrospections().get(beanType.getName());
        try {
            if (reference != null) {
                return Optional.of(reference).map(ref -> {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Found BeanIntrospection for type: {},", ref.getBeanType());
                    }
                    return ref.load();
                });
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("No BeanIntrospection found for bean type: {}", beanType);
            }
            return Optional.empty();
        }
        catch (Throwable e) {
            throw new IntrospectionException("Error loading BeanIntrospection for type [" + String.valueOf(beanType) + "]: " + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, BeanIntrospectionReference<Object>> getIntrospections() {
        Map<String, BeanIntrospectionReference<Object>> resolvedIntrospectionMap = this.introspectionMap;
        if (resolvedIntrospectionMap == null) {
            DefaultBeanIntrospector defaultBeanIntrospector = this;
            synchronized (defaultBeanIntrospector) {
                resolvedIntrospectionMap = this.introspectionMap;
                if (resolvedIntrospectionMap == null) {
                    resolvedIntrospectionMap = new HashMap<String, BeanIntrospectionReference<Object>>(30);
                    SoftServiceLoader services = this.loadReferences();
                    ArrayList beanIntrospectionReferences = new ArrayList(300);
                    services.collectAll(beanIntrospectionReferences, BeanIntrospectionReference::isPresent);
                    for (BeanIntrospectionReference reference : beanIntrospectionReferences) {
                        resolvedIntrospectionMap.put(reference.getName(), reference);
                    }
                    this.introspectionMap = resolvedIntrospectionMap;
                }
            }
        }
        return resolvedIntrospectionMap;
    }

    private SoftServiceLoader loadReferences() {
        return SoftServiceLoader.load(BeanIntrospectionReference.class, this.classLoader);
    }
}

