/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.beans;

import io.micronaut.core.annotation.AnnotatedElement;
import io.micronaut.core.annotation.AnnotationMetadataDelegate;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.exceptions.ConversionErrorException;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.ArgumentCoercible;
import io.micronaut.core.util.ArgumentUtils;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public interface BeanWriteProperty<B, T>
extends AnnotatedElement,
AnnotationMetadataDelegate,
ArgumentCoercible<T> {
    public @NonNull BeanIntrospection<B> getDeclaringBean();

    default public @NonNull Class<B> getDeclaringType() {
        return this.getDeclaringBean().getBeanType();
    }

    public B withValue(@NonNull B var1, @Nullable T var2);

    public void set(@NonNull B var1, @Nullable T var2);

    default public void convertAndSet(@NonNull B bean, @Nullable Object value) {
        ArgumentUtils.requireNonNull("bean", bean);
        if (value != null) {
            Argument<T> argument = this.asArgument();
            ArgumentConversionContext<T> context = ConversionContext.of(argument);
            T converted = ConversionService.SHARED.convert(value, context).orElseThrow(() -> new ConversionErrorException(argument, context.getLastError().orElse(() -> new IllegalArgumentException("Value [" + String.valueOf(value) + "] cannot be converted to type : " + String.valueOf(this.getType())))));
            this.set(bean, converted);
        } else {
            this.set(bean, value);
        }
    }

    public @NonNull Class<T> getType();

    @Override
    default public @NonNull Argument<T> asArgument() {
        return Argument.of(this.getType());
    }
}

