/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.beans;

import io.micronaut.core.annotation.AnnotationMetadataProvider;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.beans.BeanIntrospector;
import io.micronaut.core.beans.BeanProperty;
import io.micronaut.core.beans.DefaultBeanWrapper;
import io.micronaut.core.beans.exceptions.IntrospectionException;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ConversionError;
import io.micronaut.core.convert.exceptions.ConversionErrorException;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArgumentUtils;
import java.util.Collection;
import java.util.Optional;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public interface BeanWrapper<T>
extends AnnotationMetadataProvider {
    public @NonNull BeanIntrospection<T> getIntrospection();

    public @NonNull T getBean();

    default public @NonNull String[] getPropertyNames() {
        return this.getIntrospection().getPropertyNames();
    }

    default public @NonNull Collection<BeanProperty<T, Object>> getBeanProperties() {
        return this.getIntrospection().getBeanProperties();
    }

    default public <P> @NonNull P getRequiredProperty(@NonNull String name, @NonNull Class<P> type) {
        ArgumentUtils.requireNonNull("name", name);
        ArgumentUtils.requireNonNull("type", type);
        Argument<P> argument = Argument.of(type);
        return this.getRequiredProperty(name, argument);
    }

    default public <P> P getRequiredProperty(@NonNull String name, @NonNull Argument<P> argument) {
        ArgumentUtils.requireNonNull("name", name);
        ArgumentUtils.requireNonNull("argument", argument);
        ArgumentConversionContext<P> context = ConversionContext.of(argument);
        return this.getRequiredProperty(name, context);
    }

    default public <P> @NonNull P getRequiredProperty(@NonNull String name, @NonNull ArgumentConversionContext<P> context) {
        ArgumentUtils.requireNonNull("name", name);
        ArgumentUtils.requireNonNull("type", context);
        return (P)this.getIntrospection().getProperty(name).map(prop -> {
            Optional converted = prop.get(this.getBean(), context);
            return converted.orElseThrow(() -> {
                ConversionError conversionError = context.getLastError().orElseGet(() -> new ConversionError(){
                    final /* synthetic */ BeanProperty val$prop;
                    final /* synthetic */ ArgumentConversionContext val$context;
                    final /* synthetic */ BeanWrapper this$0;
                    {
                        this.val$prop = beanProperty;
                        this.val$context = argumentConversionContext;
                        this.this$0 = this$0;
                    }

                    @Override
                    public Exception getCause() {
                        return new IntrospectionException("Property of type [" + String.valueOf(this.val$prop.getType()) + "] cannot be converted to type: " + String.valueOf(this.val$context.getArgument().getType()));
                    }

                    @Override
                    public Optional<Object> getOriginalValue() {
                        return Optional.ofNullable(this.val$prop.get(this.this$0.getBean()));
                    }
                });
                return new ConversionErrorException(context.getArgument(), conversionError);
            });
        }).orElseThrow(() -> new IntrospectionException("No property found for name: " + name));
    }

    default public <P> @NonNull Optional<P> getProperty(@NonNull String name, @NonNull Class<P> type) {
        ArgumentUtils.requireNonNull("name", name);
        ArgumentUtils.requireNonNull("type", type);
        Argument<P> argument = Argument.of(type);
        return this.getProperty(name, argument);
    }

    default public <P> Optional<P> getProperty(@NonNull String name, Argument<P> type) {
        ArgumentUtils.requireNonNull("name", name);
        ArgumentUtils.requireNonNull("type", type);
        ArgumentConversionContext<P> context = ConversionContext.of(type);
        return this.getProperty(name, context);
    }

    default public <P> Optional<P> getProperty(@NonNull String name, ArgumentConversionContext<P> context) {
        ArgumentUtils.requireNonNull("name", name);
        ArgumentUtils.requireNonNull("context", context);
        return this.getIntrospection().getProperty(name).flatMap(prop -> prop.get(this.getBean(), context));
    }

    default public BeanWrapper<T> setProperty(@NonNull String name, @Nullable Object value) {
        ArgumentUtils.requireNonNull("name", name);
        this.getIntrospection().getProperty(name).ifPresent(prop -> prop.convertAndSet(this.getBean(), value));
        return this;
    }

    public static <T2> @NonNull BeanWrapper<T2> getWrapper(@NonNull T2 bean) {
        ArgumentUtils.requireNonNull("bean", bean);
        Class<?> aClass = bean.getClass();
        BeanIntrospection<?> introspection = BeanIntrospection.getIntrospection(aClass);
        return new DefaultBeanWrapper<T2>(bean, introspection);
    }

    public static <T2> @NonNull Optional<BeanWrapper<T2>> findWrapper(@NonNull T2 bean) {
        ArgumentUtils.requireNonNull("bean", bean);
        Class<?> aClass = bean.getClass();
        return BeanIntrospector.SHARED.findIntrospection(aClass).map(i -> new DefaultBeanWrapper<Object>(bean, (BeanIntrospection<Object>)i));
    }

    public static <T2> @NonNull Optional<BeanWrapper<T2>> findWrapper(Class<T2> type, @NonNull T2 bean) {
        ArgumentUtils.requireNonNull("type", type);
        ArgumentUtils.requireNonNull("bean", bean);
        return BeanIntrospector.SHARED.findIntrospection(type).map(i -> new DefaultBeanWrapper<Object>(bean, (BeanIntrospection<Object>)i));
    }

    public static <T2> @NonNull BeanWrapper<T2> getWrapper(Class<T2> type, @NonNull T2 bean) {
        ArgumentUtils.requireNonNull("type", type);
        ArgumentUtils.requireNonNull("bean", bean);
        BeanIntrospection<T2> introspection = BeanIntrospection.getIntrospection(type);
        return new DefaultBeanWrapper<T2>(bean, introspection);
    }
}

