/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.beans;

import io.micronaut.core.annotation.AnnotatedElement;
import io.micronaut.core.annotation.AnnotationMetadataDelegate;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.ArgumentCoercible;
import io.micronaut.core.util.ArgumentUtils;
import java.util.Optional;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public interface BeanReadProperty<B, T>
extends AnnotatedElement,
AnnotationMetadataDelegate,
ArgumentCoercible<T> {
    public @NonNull BeanIntrospection<B> getDeclaringBean();

    default public Class<B> getDeclaringType() {
        return this.getDeclaringBean().getBeanType();
    }

    public @Nullable T get(@NonNull B var1);

    default public <T2> @NonNull Optional<T2> get(@NonNull B bean, @NonNull Class<T2> type) {
        ArgumentUtils.requireNonNull("bean", bean);
        ArgumentUtils.requireNonNull("type", type);
        Argument<T2> argument = Argument.of(type);
        return this.get(bean, argument);
    }

    default public <T2> Optional<T2> get(@NonNull B bean, @NonNull Argument<T2> argument) {
        ArgumentUtils.requireNonNull("bean", bean);
        ArgumentUtils.requireNonNull("type", argument);
        ArgumentConversionContext<T2> conversionContext = ConversionContext.of(argument);
        return this.get(bean, conversionContext);
    }

    default public <T2> Optional<T2> get(@NonNull B bean, @NonNull ArgumentConversionContext<T2> conversionContext) {
        ArgumentUtils.requireNonNull("bean", bean);
        ArgumentUtils.requireNonNull("conversionContext", conversionContext);
        T v = this.get(bean);
        return ConversionService.SHARED.convert(v, conversionContext);
    }

    default public <T2> @Nullable T2 get(@NonNull B bean, @NonNull Class<T2> type, @Nullable T2 defaultValue) {
        ArgumentUtils.requireNonNull("bean", bean);
        if (type == null) {
            return defaultValue;
        }
        T v = this.get(bean);
        return ConversionService.SHARED.convert(v, type).orElse(defaultValue);
    }

    public @NonNull Class<T> getType();

    @Override
    default public @NonNull Argument<T> asArgument() {
        return Argument.of(this.getType());
    }
}

