/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.beans;

import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.beans.BeanReadProperty;
import io.micronaut.core.beans.BeanWriteProperty;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.exceptions.ConversionErrorException;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.ArgumentCoercible;
import io.micronaut.core.util.ArgumentUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public interface BeanProperty<B, T>
extends BeanReadProperty<B, T>,
BeanWriteProperty<B, T>,
ArgumentCoercible<T> {
    @Override
    public @NonNull BeanIntrospection<B> getDeclaringBean();

    @Override
    public @Nullable T get(@NonNull B var1);

    @Override
    default public <T2> @NonNull Optional<T2> get(@NonNull B bean, @NonNull Class<T2> type) {
        ArgumentUtils.requireNonNull("bean", bean);
        ArgumentUtils.requireNonNull("type", type);
        Argument<T2> argument = Argument.of(type);
        return this.get(bean, argument);
    }

    @Override
    default public <T2> Optional<T2> get(@NonNull B bean, @NonNull Argument<T2> argument) {
        ArgumentUtils.requireNonNull("bean", bean);
        ArgumentUtils.requireNonNull("type", argument);
        ArgumentConversionContext<T2> conversionContext = ConversionContext.of(argument);
        return this.get(bean, conversionContext);
    }

    @Override
    default public <T2> Optional<T2> get(@NonNull B bean, @NonNull ArgumentConversionContext<T2> conversionContext) {
        ArgumentUtils.requireNonNull("bean", bean);
        ArgumentUtils.requireNonNull("conversionContext", conversionContext);
        T v = this.get(bean);
        return ConversionService.SHARED.convert(v, conversionContext);
    }

    @Override
    default public <T2> @Nullable T2 get(@NonNull B bean, @NonNull Class<T2> type, @Nullable T2 defaultValue) {
        ArgumentUtils.requireNonNull("bean", bean);
        if (type == null) {
            return defaultValue;
        }
        T v = this.get(bean);
        return ConversionService.SHARED.convert(v, type).orElse(defaultValue);
    }

    default public boolean hasSetterOrConstructorArgument() {
        BeanIntrospection declaringBean = this.getDeclaringBean();
        return !this.isReadOnly() || Arrays.stream(declaringBean.getConstructorArguments()).anyMatch(arg -> declaringBean.getProperty(arg.getName(), arg.getType()).isPresent());
    }

    @Override
    default public B withValue(@NonNull B bean, @Nullable T value) {
        if (this.isReadOnly()) {
            if (value == this.get(bean)) {
                return bean;
            }
            BeanIntrospection<B> declaringBean = this.getDeclaringBean();
            Argument<?>[] constructorArguments = declaringBean.getConstructorArguments();
            Object[] values = new Object[constructorArguments.length];
            boolean found = false;
            for (int i = 0; i < constructorArguments.length; ++i) {
                Class argumentType;
                Argument<?> constructorArgument = constructorArguments[i];
                String argumentName = constructorArgument.getName();
                BeanProperty prop = declaringBean.getProperty(argumentName, argumentType = constructorArgument.getType()).orElse(null);
                if (prop == null) {
                    throw new UnsupportedOperationException("Cannot create copy of type [" + String.valueOf(declaringBean.getBeanType()) + "]. Constructor contains argument [" + argumentName + "] that is not a readable property");
                }
                if (prop == this) {
                    found = true;
                    values[i] = value;
                    continue;
                }
                values[i] = prop.get(bean);
            }
            B newInstance = declaringBean.instantiate(values);
            Collection<BeanProperty<B, Object>> beanProperties = declaringBean.getBeanProperties();
            if (found) {
                for (BeanProperty<B, Object> beanProperty : beanProperties) {
                    if (beanProperty == this || !beanProperty.isReadWrite()) continue;
                    beanProperty.set(newInstance, beanProperty.get(bean));
                }
                return newInstance;
            }
            for (BeanProperty<B, Object> beanProperty : beanProperties) {
                if (beanProperty != this || !beanProperty.isReadWrite()) continue;
                found = true;
                beanProperty.set(newInstance, beanProperty.get(bean));
            }
            if (!found) {
                throw new UnsupportedOperationException("Cannot mutate property [" + this.getName() + "] that is not mutable via a setter method or constructor argument for type: " + declaringBean.getBeanType().getName());
            }
            return newInstance;
        }
        this.set(bean, value);
        return bean;
    }

    @Override
    default public void set(@NonNull B bean, @Nullable T value) {
        if (this.isReadOnly()) {
            throw new UnsupportedOperationException("Cannot write read-only property: " + this.getName());
        }
        throw new UnsupportedOperationException("Write method unimplemented for property: " + this.getName());
    }

    @Override
    default public void convertAndSet(@NonNull B bean, @Nullable Object value) {
        ArgumentUtils.requireNonNull("bean", bean);
        if (value != null) {
            Argument<T> argument = this.asArgument();
            ArgumentConversionContext<T> context = ConversionContext.of(argument);
            T converted = ConversionService.SHARED.convert(value, context).orElseThrow(() -> new ConversionErrorException(argument, context.getLastError().orElse(() -> new IllegalArgumentException("Value [" + String.valueOf(value) + "] cannot be converted to type : " + String.valueOf(this.getType())))));
            this.set(bean, converted);
        } else {
            this.set(bean, value);
        }
    }

    @Override
    public @NonNull Class<T> getType();

    @Override
    default public @NonNull Argument<T> asArgument() {
        return Argument.of(this.getType());
    }

    default public boolean isReadOnly() {
        return false;
    }

    default public boolean isWriteOnly() {
        return false;
    }

    default public boolean isReadWrite() {
        return !this.isReadOnly() && !this.isWriteOnly();
    }

    @Override
    default public Class<B> getDeclaringType() {
        return this.getDeclaringBean().getBeanType();
    }
}

