/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.beans;

import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.beans.BeanIntrospectionMap;
import io.micronaut.core.beans.BeanIntrospector;
import io.micronaut.core.util.ArgumentUtils;
import java.util.Map;
import org.jspecify.annotations.NonNull;

public interface BeanMap<T>
extends Map<String, Object> {
    public @NonNull Class<T> getBeanType();

    public static <B> @NonNull BeanMap<B> of(@NonNull B bean) {
        ArgumentUtils.requireNonNull("bean", bean);
        BeanIntrospection<?> introspection = BeanIntrospector.SHARED.getIntrospection(bean.getClass());
        return new BeanIntrospectionMap(introspection, bean);
    }
}

