/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.beans;

import io.micronaut.core.annotation.AnnotationMetadataDelegate;
import io.micronaut.core.beans.BeanConstructor;
import io.micronaut.core.beans.BeanInfo;
import io.micronaut.core.beans.BeanIntrospector;
import io.micronaut.core.beans.BeanMethod;
import io.micronaut.core.beans.BeanProperty;
import io.micronaut.core.beans.BeanReadProperty;
import io.micronaut.core.beans.BeanWriteProperty;
import io.micronaut.core.beans.exceptions.IntrospectionException;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.naming.Named;
import io.micronaut.core.reflect.exception.InstantiationException;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArgumentUtils;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public interface BeanIntrospection<T>
extends AnnotationMetadataDelegate,
BeanInfo<T> {
    public @NonNull Collection<BeanProperty<T, Object>> getBeanProperties();

    default public @NonNull List<BeanReadProperty<T, Object>> getBeanReadProperties() {
        return List.of();
    }

    default public @NonNull List<BeanWriteProperty<T, Object>> getBeanWriteProperties() {
        return List.of();
    }

    public @NonNull Collection<BeanProperty<T, Object>> getIndexedProperties(@NonNull Class<? extends Annotation> var1);

    public @NonNull Builder<T> builder();

    default public boolean isBuildable() {
        return false;
    }

    default public boolean hasBuilder() {
        return false;
    }

    public @NonNull T instantiate() throws InstantiationException;

    default public @NonNull T instantiate(Object ... arguments) throws InstantiationException {
        return this.instantiate(true, arguments);
    }

    public @NonNull T instantiate(boolean var1, Object ... var2) throws InstantiationException;

    @Override
    public @NonNull Class<T> getBeanType();

    public @NonNull Optional<BeanProperty<T, Object>> getIndexedProperty(@NonNull Class<? extends Annotation> var1, @NonNull String var2);

    default public @NonNull Collection<BeanMethod<T, Object>> getBeanMethods() {
        return Collections.emptyList();
    }

    default public @NonNull Optional<BeanProperty<T, Object>> getIndexedProperty(@NonNull Class<? extends Annotation> annotationType) {
        return this.getIndexedProperties(annotationType).stream().findFirst();
    }

    default public @NonNull Argument<?>[] getConstructorArguments() {
        return Argument.ZERO_ARGUMENTS;
    }

    default public @NonNull Optional<BeanProperty<T, Object>> getProperty(@NonNull String name) {
        return this.getBeanProperties().stream().filter(p -> p.getName().equals(name)).findFirst();
    }

    default public @NonNull Optional<BeanReadProperty<T, Object>> getReadProperty(@NonNull String name) {
        return this.getBeanReadProperties().stream().filter(p -> p.getName().equals(name)).findFirst();
    }

    default public @NonNull Optional<BeanWriteProperty<T, Object>> getWriteProperty(@NonNull String name) {
        return this.getBeanWriteProperties().stream().filter(p -> p.getName().equals(name)).findFirst();
    }

    default public int propertyIndexOf(@NonNull String name) {
        int index = 0;
        for (BeanProperty<T, Object> property : this.getBeanProperties()) {
            if (property.getName().equals(name)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    default public <P> @NonNull BeanProperty<T, P> getRequiredProperty(@NonNull String name, @NonNull Class<P> type) {
        return this.getProperty(name, type).orElseThrow(() -> new IntrospectionException("No property [" + name + "] of type [" + String.valueOf(type) + "] present"));
    }

    default public <P> @NonNull BeanReadProperty<T, P> getRequiredReadProperty(@NonNull String name, @NonNull Class<P> type) {
        return this.getReadProperty(name, type).orElseThrow(() -> new IntrospectionException("No read property [" + name + "] of type [" + String.valueOf(type) + "] present"));
    }

    default public <P> @NonNull BeanWriteProperty<T, P> getRequiredWriteProperty(@NonNull String name, @NonNull Class<P> type) {
        return this.getWriteProperty(name, type).orElseThrow(() -> new IntrospectionException("No write property [" + name + "] of type [" + String.valueOf(type) + "] present"));
    }

    default public <P> @NonNull Optional<BeanProperty<T, P>> getProperty(@NonNull String name, @NonNull Class<P> type) {
        ArgumentUtils.requireNonNull("name", name);
        ArgumentUtils.requireNonNull("type", type);
        BeanProperty prop = this.getProperty(name).orElse(null);
        if (prop != null && type.isAssignableFrom(prop.getType())) {
            return Optional.of(prop);
        }
        return Optional.empty();
    }

    default public <P> @NonNull Optional<BeanReadProperty<T, P>> getReadProperty(@NonNull String name, @NonNull Class<P> type) {
        ArgumentUtils.requireNonNull("name", name);
        ArgumentUtils.requireNonNull("type", type);
        BeanReadProperty prop = this.getReadProperty(name).orElse(null);
        if (prop != null && type.isAssignableFrom(prop.getType())) {
            return Optional.of(prop);
        }
        return Optional.empty();
    }

    default public <P> @NonNull Optional<BeanWriteProperty<T, P>> getWriteProperty(@NonNull String name, @NonNull Class<P> type) {
        ArgumentUtils.requireNonNull("name", name);
        ArgumentUtils.requireNonNull("type", type);
        BeanWriteProperty prop = this.getWriteProperty(name).orElse(null);
        if (prop != null && type.isAssignableFrom(prop.getType())) {
            return Optional.of((BeanProperty)prop);
        }
        return Optional.empty();
    }

    default public @NonNull String[] getPropertyNames() {
        return (String[])this.getBeanProperties().stream().map(Named::getName).toArray(String[]::new);
    }

    default public @NonNull String[] getReadPropertyNames() {
        return (String[])this.getBeanReadProperties().stream().map(Named::getName).toArray(String[]::new);
    }

    default public @NonNull BeanConstructor<T> getConstructor() {
        return new BeanConstructor<T>(){

            @Override
            public @NonNull Class<T> getDeclaringBeanType() {
                return BeanIntrospection.this.getBeanType();
            }

            @Override
            public @NonNull Argument<?>[] getArguments() {
                return BeanIntrospection.this.getConstructorArguments();
            }

            @Override
            public @NonNull T instantiate(Object ... parameterValues) {
                return BeanIntrospection.this.instantiate(parameterValues);
            }
        };
    }

    public static <T2> BeanIntrospection<T2> getIntrospection(Class<T2> type) {
        return BeanIntrospector.SHARED.getIntrospection(type);
    }

    public static interface Builder<T> {
        public @NonNull Argument<?>[] getBuilderArguments();

        public @NonNull Argument<?>[] getBuildMethodArguments();

        public int indexOf(String var1);

        public @NonNull Builder<T> with(@NonNull String var1, @Nullable Object var2);

        public @NonNull Builder<T> with(T var1);

        public <A> @NonNull Builder<T> with(int var1, @NonNull Argument<A> var2, @Nullable A var3);

        public <A> @NonNull Builder<T> convert(int var1, @NonNull ArgumentConversionContext<A> var2, @Nullable Object var3, @NonNull ConversionService var4);

        public @NonNull T build();

        public @NonNull T build(Object ... var1);
    }
}

