/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.beans;

import io.micronaut.core.annotation.AnnotationMetadataProvider;
import io.micronaut.core.naming.Described;
import io.micronaut.core.type.Argument;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.jspecify.annotations.NonNull;

public interface BeanConstructor<T>
extends AnnotationMetadataProvider,
Described {
    public @NonNull Class<T> getDeclaringBeanType();

    public @NonNull Argument<?>[] getArguments();

    public @NonNull T instantiate(Object ... var1);

    @Override
    default public @NonNull String getDescription() {
        return this.getDescription(true);
    }

    @Override
    default public @NonNull String getDescription(boolean simple) {
        String args = Arrays.stream(this.getArguments()).map(arg -> arg.getTypeString(simple) + " " + arg.getName()).collect(Collectors.joining(","));
        return this.getDeclaringBeanType().getSimpleName() + "(" + args + ")";
    }
}

