/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.beans;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.beans.UnsafeBeanProperty;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.core.util.ObjectUtils;
import java.util.Objects;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Internal
public abstract class AbstractBeanProperty<B, P>
implements UnsafeBeanProperty<B, P> {
    private final BeanIntrospection<B> introspection;
    private final Class<B> beanType;
    private final Class<P> type;
    private final String name;
    private final AnnotationMetadata annotationMetadata;
    private final Argument[] typeArguments;
    private final Class<?> typeOrWrapperType;

    @Internal
    protected AbstractBeanProperty(@NonNull BeanIntrospection<B> introspection, @NonNull Class<P> type, @NonNull String name, @Nullable AnnotationMetadata annotationMetadata, @Nullable Argument[] typeArguments) {
        this.introspection = introspection;
        this.type = type;
        this.beanType = introspection.getBeanType();
        this.name = name;
        this.annotationMetadata = annotationMetadata == null ? AnnotationMetadata.EMPTY_METADATA : annotationMetadata;
        this.typeArguments = typeArguments;
        this.typeOrWrapperType = ReflectionUtils.getWrapperType(type);
    }

    @Override
    public @NonNull String getName() {
        return this.name;
    }

    @Override
    public @NonNull Class<P> getType() {
        return this.type;
    }

    @Override
    public @NonNull Argument<P> asArgument() {
        if (this.typeArguments != null) {
            return Argument.of(this.type, this.name, this.getAnnotationMetadata(), this.typeArguments);
        }
        return Argument.of(this.type, this.name, this.getAnnotationMetadata(), new Argument[0]);
    }

    @Override
    public final @NonNull BeanIntrospection<B> getDeclaringBean() {
        return this.introspection;
    }

    @Override
    public AnnotationMetadata getAnnotationMetadata() {
        return this.annotationMetadata;
    }

    @Override
    public final @Nullable P get(@NonNull B bean) {
        ArgumentUtils.requireNonNull("bean", bean);
        if (!this.beanType.isInstance(bean)) {
            throw new IllegalArgumentException("Invalid bean [" + String.valueOf(bean) + "] for type: " + String.valueOf(this.introspection.getBeanType()));
        }
        if (this.isWriteOnly()) {
            throw new UnsupportedOperationException("Cannot read from a write-only property");
        }
        return this.readInternal(bean);
    }

    @Override
    public final P getUnsafe(B bean) {
        return this.readInternal(bean);
    }

    @Override
    public B withValue(@NonNull B bean, @Nullable P value) {
        ArgumentUtils.requireNonNull("bean", bean);
        if (!this.beanType.isInstance(bean)) {
            throw new IllegalArgumentException("Invalid bean [" + String.valueOf(bean) + "] for type: " + String.valueOf(this.introspection.getBeanType()));
        }
        return this.withValueUnsafe(bean, value);
    }

    @Override
    public final B withValueUnsafe(B bean, P value) {
        if (value == this.getUnsafe(bean)) {
            return bean;
        }
        return this.withValueInternal(bean, value);
    }

    @Override
    public final void set(@NonNull B bean, @Nullable P value) {
        ArgumentUtils.requireNonNull("bean", bean);
        if (!this.beanType.isInstance(bean)) {
            throw new IllegalArgumentException("Invalid bean [" + String.valueOf(bean) + "] for type: " + String.valueOf(this.beanType));
        }
        if (this.isReadOnly()) {
            throw new UnsupportedOperationException("Cannot write a read-only property: " + this.getName());
        }
        if (value != null && !this.typeOrWrapperType.isInstance(value)) {
            throw new IllegalArgumentException("Specified value [" + String.valueOf(value) + "] is not of the correct type: " + String.valueOf(this.getType()));
        }
        this.writeInternal(bean, value);
    }

    @Override
    public final void setUnsafe(B bean, P value) {
        this.writeInternal(bean, value);
    }

    @Internal
    protected B withValueInternal(B bean, P value) {
        return UnsafeBeanProperty.super.withValue(bean, value);
    }

    @Internal
    protected abstract void writeInternal(@NonNull B var1, @Nullable P var2);

    @Internal
    protected abstract P readInternal(@NonNull B var1);

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractBeanProperty that = (AbstractBeanProperty)o;
        return Objects.equals(this.beanType, that.beanType) && Objects.equals(this.type, that.type) && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return ObjectUtils.hash(this.beanType, this.type, this.name);
    }

    public String toString() {
        return "BeanProperty{beanType=" + String.valueOf(this.beanType) + ", type=" + String.valueOf(this.type) + ", name='" + this.name + "'}";
    }
}

