/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.attr;

import io.micronaut.core.attr.AttributeHolder;
import io.micronaut.core.convert.value.MutableConvertibleValues;
import io.micronaut.core.util.StringUtils;
import java.util.Optional;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public interface MutableAttributeHolder
extends AttributeHolder {
    public @NonNull MutableConvertibleValues<Object> getAttributes();

    default public @NonNull MutableAttributeHolder setAttribute(@NonNull CharSequence name, @Nullable Object value) {
        if (StringUtils.isNotEmpty(name)) {
            if (value == null) {
                this.getAttributes().remove(name.toString());
            } else {
                this.getAttributes().put(name.toString(), value);
            }
        }
        return this;
    }

    default public <T> @NonNull Optional<T> removeAttribute(@NonNull CharSequence name, @NonNull Class<T> type) {
        if (StringUtils.isNotEmpty(name)) {
            String key = name.toString();
            Optional<Object> value = this.getAttribute(key, type);
            value.ifPresent(o -> this.getAttributes().remove(key));
            return value;
        }
        return Optional.empty();
    }
}

