/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.propagation;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.propagation.PropagatedContextImpl;
import io.netty.util.concurrent.FastThreadLocal;

@Internal
final class ThreadContext {
    private static final Object FAST;
    private static final ThreadLocal<PropagatedContextImpl> SLOW;

    ThreadContext() {
    }

    static void remove() {
        if (FAST == null) {
            SLOW.remove();
        } else {
            ((FastThreadLocal)FAST).remove();
        }
    }

    static PropagatedContextImpl get() {
        if (FAST == null) {
            return SLOW.get();
        }
        return (PropagatedContextImpl)((FastThreadLocal)FAST).get();
    }

    static void set(PropagatedContextImpl value) {
        if (FAST == null) {
            SLOW.set(value);
        } else {
            ((FastThreadLocal)FAST).set((Object)value);
        }
    }

    static {
        ThreadLocal<PropagatedContextImpl> slow;
        FastThreadLocal fast;
        try {
            fast = new FastThreadLocal();
            slow = null;
        }
        catch (NoClassDefFoundError e) {
            fast = null;
            slow = new ThreadLocal<PropagatedContextImpl>(){

                public String toString() {
                    return "Micronaut Propagation Context";
                }
            };
        }
        FAST = fast;
        SLOW = slow;
    }
}

