/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.propagation;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.propagation.PropagatedContextImpl;
import io.netty.util.concurrent.FastThreadLocal;
import io.netty.util.concurrent.FastThreadLocalThread;

@Internal
final class ThreadContext {
    private static final Object FAST;
    private static final ThreadLocal<PropagatedContextImpl> SLOW;

    ThreadContext() {
    }

    private static boolean useSlow() {
        return FAST == null || !(Thread.currentThread() instanceof FastThreadLocalThread);
    }

    static void remove() {
        if (ThreadContext.useSlow()) {
            SLOW.remove();
        } else {
            ((FastThreadLocal)FAST).remove();
        }
    }

    static PropagatedContextImpl get() {
        if (ThreadContext.useSlow()) {
            return SLOW.get();
        }
        return (PropagatedContextImpl)((FastThreadLocal)FAST).get();
    }

    static void set(PropagatedContextImpl value) {
        if (ThreadContext.useSlow()) {
            SLOW.set(value);
        } else {
            ((FastThreadLocal)FAST).set((Object)value);
        }
    }

    static {
        FastThreadLocal fast;
        SLOW = new ThreadLocal<PropagatedContextImpl>(){

            public String toString() {
                return "Micronaut Propagation Context";
            }
        };
        try {
            fast = new FastThreadLocal();
        }
        catch (NoClassDefFoundError e) {
            fast = null;
        }
        FAST = fast;
    }
}

