/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.scheduling.executor;

import io.micronaut.core.annotation.Internal;
import io.micronaut.runtime.graceful.GracefulShutdownCapable;
import java.util.OptionalLong;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.LongAdder;
import org.jspecify.annotations.NonNull;

@Internal
final class GracefulShutdownCapableScheduledThreadPoolExecutor
extends ScheduledThreadPoolExecutor
implements GracefulShutdownCapable {
    private final CompletableFuture<Void> terminationFuture = new CompletableFuture();
    private final LongAdder running = new LongAdder();

    public GracefulShutdownCapableScheduledThreadPoolExecutor(int corePoolSize, ThreadFactory threadFactory) {
        super(corePoolSize, threadFactory);
        this.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
        this.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
    }

    @Override
    public @NonNull CompletionStage<?> shutdownGracefully() {
        this.shutdown();
        return this.terminationFuture;
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        super.beforeExecute(t, r);
        this.running.increment();
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
        this.running.decrement();
    }

    @Override
    protected void terminated() {
        super.terminated();
        this.terminationFuture.complete(null);
    }

    @Override
    public OptionalLong reportActiveTasks() {
        return OptionalLong.of(this.running.sum());
    }
}

