/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.scheduling;

import io.micronaut.context.annotation.Primary;
import io.micronaut.scheduling.TaskExceptionHandler;
import jakarta.inject.Singleton;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Primary
public class DefaultTaskExceptionHandler
implements TaskExceptionHandler<Object, Throwable> {
    static final Logger LOG = LoggerFactory.getLogger(DefaultTaskExceptionHandler.class);

    public void handle(@Nullable Object bean, @NonNull Throwable throwable) {
        if (LOG.isErrorEnabled()) {
            StringBuilder message = new StringBuilder("Error invoking scheduled task ");
            if (bean != null) {
                message.append("for bean [").append(bean).append("] ");
            }
            message.append(throwable.getMessage());
            LOG.error(message.toString(), throwable);
        }
    }
}

