/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.runtime.graceful;

import io.micronaut.context.annotation.Requires;
import io.micronaut.runtime.graceful.GracefulShutdownCapable;
import jakarta.inject.Singleton;
import java.util.List;
import java.util.OptionalLong;
import java.util.concurrent.CompletionStage;
import org.jspecify.annotations.NonNull;

@Singleton
@Requires(classes={GracefulShutdownCapable.class})
public final class GracefulShutdownManager {
    private final List<GracefulShutdownCapable> delegates;

    GracefulShutdownManager(List<GracefulShutdownCapable> delegates) {
        this.delegates = delegates;
    }

    public @NonNull CompletionStage<?> shutdownGracefully() {
        return GracefulShutdownCapable.shutdownAll(this.delegates.stream());
    }

    public @NonNull OptionalLong reportActiveTasks() {
        return GracefulShutdownCapable.combineActiveTasks(this.delegates);
    }
}

