/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.runtime.graceful;

import io.micronaut.runtime.graceful.LogHolder;
import java.util.OptionalLong;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Stream;
import org.jspecify.annotations.NonNull;

public interface GracefulShutdownCapable {
    public @NonNull CompletionStage<?> shutdownGracefully();

    default public OptionalLong reportActiveTasks() {
        return OptionalLong.empty();
    }

    public static @NonNull CompletionStage<?> allOf(@NonNull Stream<CompletionStage<?>> stages) {
        return CompletableFuture.allOf((CompletableFuture[])stages.map(CompletionStage::toCompletableFuture).toArray(CompletableFuture[]::new));
    }

    public static @NonNull CompletionStage<?> shutdownAll(@NonNull Stream<? extends GracefulShutdownCapable> stages) {
        return CompletableFuture.allOf((CompletableFuture[])stages.map(l -> {
            CompletionStage<?> s;
            try {
                s = l.shutdownGracefully();
            }
            catch (Exception e) {
                LogHolder.LOG.warn("Exception when attempting graceful shutdown", (Throwable)e);
                return CompletableFuture.completedFuture(null);
            }
            return s.toCompletableFuture();
        }).toArray(CompletableFuture[]::new));
    }

    public static @NonNull OptionalLong combineActiveTasks(@NonNull Iterable<? extends GracefulShutdownCapable> delegates) {
        long sum = 0L;
        boolean anyPresent = false;
        for (GracefulShutdownCapable gracefulShutdownCapable : delegates) {
            OptionalLong r = gracefulShutdownCapable.reportActiveTasks();
            if (!r.isPresent()) continue;
            anyPresent = true;
            sum += r.getAsLong();
        }
        return anyPresent ? OptionalLong.of(sum) : OptionalLong.empty();
    }
}

