/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.scheduling.executor;

import io.micronaut.context.BeanLocator;
import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.core.reflect.InstantiationUtils;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.scheduling.LoomSupport;
import io.micronaut.scheduling.executor.ExecutorConfiguration;
import io.micronaut.scheduling.executor.ExecutorType;
import io.micronaut.scheduling.executor.NamedThreadFactory;
import jakarta.inject.Inject;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

@Factory
public class ExecutorFactory {
    private final BeanLocator beanLocator;
    private final ThreadFactory threadFactory;

    @Inject
    public ExecutorFactory(BeanLocator beanLocator, ThreadFactory threadFactory) {
        this.beanLocator = beanLocator;
        this.threadFactory = threadFactory;
    }

    @EachBean(value=ExecutorConfiguration.class)
    protected ThreadFactory eventLoopGroupThreadFactory(ExecutorConfiguration configuration) {
        String name = configuration.getName();
        if (configuration.isVirtual()) {
            if (name == null) {
                name = "virtual";
            }
            return LoomSupport.newVirtualThreadFactory(name + "-executor");
        }
        if (name != null) {
            return new NamedThreadFactory(name + "-executor");
        }
        return this.threadFactory;
    }

    @EachBean(value=ExecutorConfiguration.class)
    @Bean(preDestroy="shutdown")
    public ExecutorService executorService(ExecutorConfiguration executorConfiguration) {
        ExecutorType executorType = executorConfiguration.getType();
        switch (executorType) {
            case FIXED: {
                return Executors.newFixedThreadPool(executorConfiguration.getNumberOfThreads(), this.getThreadFactory(executorConfiguration));
            }
            case CACHED: {
                return Executors.newCachedThreadPool(this.getThreadFactory(executorConfiguration));
            }
            case SCHEDULED: {
                return Executors.newScheduledThreadPool(executorConfiguration.getCorePoolSize(), this.getThreadFactory(executorConfiguration));
            }
            case WORK_STEALING: {
                return Executors.newWorkStealingPool(executorConfiguration.getParallelism());
            }
            case THREAD_PER_TASK: {
                return LoomSupport.newThreadPerTaskExecutor(this.getThreadFactory(executorConfiguration));
            }
        }
        throw new IllegalStateException("Could not create Executor service for enum value: " + String.valueOf((Object)executorType));
    }

    private ThreadFactory getThreadFactory(ExecutorConfiguration executorConfiguration) {
        return executorConfiguration.getThreadFactoryClass().flatMap(InstantiationUtils::tryInstantiate).map(ThreadFactory.class::cast).orElseGet(() -> {
            if (this.beanLocator != null) {
                if (executorConfiguration.getName() == null) {
                    return (ThreadFactory)this.beanLocator.getBean(ThreadFactory.class);
                }
                return (ThreadFactory)this.beanLocator.getBean(ThreadFactory.class, Qualifiers.byName((String)executorConfiguration.getName()));
            }
            throw new IllegalStateException("No bean factory configured");
        });
    }
}

