/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.runtime.server.watch.event;

import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.event.ApplicationEventListener;
import io.micronaut.runtime.server.EmbeddedServer;
import io.micronaut.scheduling.io.watch.event.FileChangedEvent;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Requirements(value={@Requires(beans={EmbeddedServer.class}), @Requires(property="micronaut.io.watch.restart", value="true", defaultValue="false")})
public class FileWatchRestartListener
implements ApplicationEventListener<FileChangedEvent> {
    private static final Logger LOG = LoggerFactory.getLogger(FileWatchRestartListener.class);
    private final EmbeddedServer embeddedServer;

    public FileWatchRestartListener(EmbeddedServer embeddedServer) {
        this.embeddedServer = embeddedServer;
    }

    public void onApplicationEvent(FileChangedEvent event) {
        this.embeddedServer.stop();
        if (LOG.isInfoEnabled()) {
            LOG.info("Shutting down server following file change.");
        }
        System.exit(0);
    }

    public boolean supports(FileChangedEvent event) {
        return true;
    }
}

