/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.buffer.netty;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.io.buffer.ReferenceCounted;
import io.micronaut.core.util.ArrayUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;

@Internal
final class NettyByteBuffer
implements io.micronaut.core.io.buffer.ByteBuffer<ByteBuf>,
ReferenceCounted {
    private ByteBuf delegate;

    NettyByteBuffer(ByteBuf delegate) {
        this.delegate = delegate;
    }

    public NettyByteBuffer retain() {
        this.delegate.retain();
        return this;
    }

    public ByteBuf asNativeBuffer() {
        return this.delegate;
    }

    public boolean release() {
        return this.delegate.release();
    }

    public int readableBytes() {
        return this.delegate.readableBytes();
    }

    public int writableBytes() {
        return this.delegate.writableBytes();
    }

    public int maxCapacity() {
        return this.delegate.maxCapacity();
    }

    public io.micronaut.core.io.buffer.ByteBuffer capacity(int capacity) {
        this.delegate.capacity(capacity);
        return this;
    }

    public int readerIndex() {
        return this.delegate.readerIndex();
    }

    public io.micronaut.core.io.buffer.ByteBuffer readerIndex(int readPosition) {
        this.delegate.readerIndex(readPosition);
        return this;
    }

    public int writerIndex() {
        return this.delegate.writerIndex();
    }

    public io.micronaut.core.io.buffer.ByteBuffer writerIndex(int position) {
        this.delegate.writerIndex(position);
        return this;
    }

    public byte read() {
        return this.delegate.readByte();
    }

    public CharSequence readCharSequence(int length, Charset charset) {
        return this.delegate.readCharSequence(length, charset);
    }

    public io.micronaut.core.io.buffer.ByteBuffer read(byte[] destination) {
        this.delegate.readBytes(destination);
        return this;
    }

    public io.micronaut.core.io.buffer.ByteBuffer read(byte[] destination, int offset, int length) {
        this.delegate.readBytes(destination, offset, length);
        return this;
    }

    public io.micronaut.core.io.buffer.ByteBuffer write(byte b) {
        this.delegate.writeByte((int)b);
        return this;
    }

    public io.micronaut.core.io.buffer.ByteBuffer write(byte[] source) {
        this.delegate.writeBytes(source);
        return this;
    }

    public io.micronaut.core.io.buffer.ByteBuffer write(CharSequence source, Charset charset) {
        this.delegate.writeCharSequence(source, charset);
        return this;
    }

    public io.micronaut.core.io.buffer.ByteBuffer write(byte[] source, int offset, int length) {
        this.delegate.writeBytes(source, offset, length);
        return this;
    }

    public io.micronaut.core.io.buffer.ByteBuffer write(io.micronaut.core.io.buffer.ByteBuffer ... buffers) {
        if (ArrayUtils.isNotEmpty((Object[])buffers)) {
            ByteBuf[] byteBufs = (ByteBuf[])Arrays.stream(buffers).map(buffer -> {
                if (buffer instanceof NettyByteBuffer) {
                    NettyByteBuffer byteBuffer = (NettyByteBuffer)buffer;
                    return byteBuffer.asNativeBuffer();
                }
                return Unpooled.wrappedBuffer((ByteBuffer)buffer.asNioBuffer());
            }).toArray(ByteBuf[]::new);
            return this.write(byteBufs);
        }
        return this;
    }

    public io.micronaut.core.io.buffer.ByteBuffer write(ByteBuffer ... buffers) {
        if (ArrayUtils.isNotEmpty((Object[])buffers)) {
            ByteBuf[] byteBufs = (ByteBuf[])Arrays.stream(buffers).map(Unpooled::wrappedBuffer).toArray(ByteBuf[]::new);
            return this.write(byteBufs);
        }
        return this;
    }

    public io.micronaut.core.io.buffer.ByteBuffer write(ByteBuf ... byteBufs) {
        ByteBuf byteBuf = this.delegate;
        if (byteBuf instanceof CompositeByteBuf) {
            CompositeByteBuf compositeByteBuf = (CompositeByteBuf)byteBuf;
            compositeByteBuf.addComponents(true, byteBufs);
        } else {
            ByteBuf current = this.delegate;
            CompositeByteBuf composite = current.alloc().compositeBuffer(byteBufs.length + 1);
            this.delegate = composite;
            composite.addComponent(true, current);
            composite.addComponents(true, byteBufs);
        }
        return this;
    }

    public io.micronaut.core.io.buffer.ByteBuffer slice(int index, int length) {
        return new NettyByteBuffer(this.delegate.slice(index, length));
    }

    public ByteBuffer asNioBuffer() {
        return this.delegate.nioBuffer();
    }

    public ByteBuffer asNioBuffer(int index, int length) {
        return this.delegate.nioBuffer(index, length);
    }

    public InputStream toInputStream() {
        return new ByteBufInputStream(this.delegate);
    }

    public OutputStream toOutputStream() {
        return new ByteBufOutputStream(this.delegate);
    }

    public byte[] toByteArray() {
        return ByteBufUtil.getBytes((ByteBuf)this.delegate);
    }

    public String toString(Charset charset) {
        return this.delegate.toString(charset);
    }

    public int indexOf(byte b) {
        return this.delegate.bytesBefore(b);
    }

    public byte getByte(int index) {
        return this.delegate.getByte(index);
    }
}

