/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.writer;

import io.micronaut.asm.ClassVisitor;
import io.micronaut.asm.ClassWriter;
import io.micronaut.asm.MethodVisitor;
import io.micronaut.asm.Opcodes;
import io.micronaut.asm.Type;
import io.micronaut.asm.commons.GeneratorAdapter;
import io.micronaut.asm.commons.Method;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.inject.writer.ClassGenerationException;
import io.micronaut.inject.writer.ClassWriterOutputVisitor;
import io.micronaut.inject.writer.DirectoryClassWriterOutputVisitor;
import io.micronaut.inject.writer.GeneratedFile;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

@Internal
public abstract class AbstractClassFileWriter
implements Opcodes {
    protected static final String CONSTRUCTOR_NAME = "<init>";
    protected static final String DESCRIPTOR_DEFAULT_CONSTRUCTOR = "()V";
    protected static final Method METHOD_DEFAULT_CONSTRUCTOR = new Method("<init>", "()V");
    protected static final Type TYPE_OBJECT = Type.getType(Object.class);
    protected static final Type TYPE_CLASS = Type.getType(Class.class);
    protected static final int DEFAULT_MAX_STACK = 13;
    protected static final Map<String, String> NAME_TO_TYPE_MAP = new HashMap<String, String>();

    public void writeTo(File targetDir) throws IOException {
        this.accept(this.newClassWriterOutputVisitor(targetDir));
    }

    public abstract void accept(ClassWriterOutputVisitor var1) throws IOException;

    protected static String getTypeDescriptor(Object type) {
        if (type instanceof Class) {
            return Type.getDescriptor((Class)((Class)type));
        }
        String className = type.toString();
        return AbstractClassFileWriter.getTypeDescriptor(className, new String[0]);
    }

    protected static Type getTypeReferenceForName(String className, String ... genericTypes) {
        String referenceString = AbstractClassFileWriter.getTypeDescriptor(className, genericTypes);
        return Type.getType((String)referenceString);
    }

    protected static Type getTypeReference(Object type) {
        if (type instanceof Class) {
            return Type.getType((Class)((Class)type));
        }
        if (type instanceof String) {
            String className = type.toString();
            String internalName = AbstractClassFileWriter.getInternalName(className);
            if (className.endsWith("[]")) {
                internalName = "[L" + internalName + ";";
            }
            return Type.getObjectType((String)internalName);
        }
        throw new IllegalArgumentException("Type reference [" + type + "] should be a Class or a String representing the class name");
    }

    protected static void pushBoxPrimitiveIfNecessary(Object fieldType, MethodVisitor injectMethodVisitor) {
        Class wrapperType = AbstractClassFileWriter.getWrapperType(fieldType);
        if (wrapperType != null) {
            Class primitiveType = (Class)fieldType;
            Type wrapper = Type.getType((Class)wrapperType);
            String primitiveName = primitiveType.getName();
            String sig = wrapperType.getName() + " valueOf(" + primitiveName + ")";
            Method valueOfMethod = Method.getMethod((String)sig);
            injectMethodVisitor.visitMethodInsn(184, wrapper.getInternalName(), "valueOf", valueOfMethod.getDescriptor(), false);
        }
    }

    protected static void pushCastToType(MethodVisitor methodVisitor, Object type) {
        Class typeClass;
        String internalName = AbstractClassFileWriter.getInternalNameForCast(type);
        methodVisitor.visitTypeInsn(192, internalName);
        if (type instanceof Class && (typeClass = (Class)type).isPrimitive()) {
            Type primitiveType = Type.getType((Class)typeClass);
            Method valueMethod = null;
            switch (primitiveType.getSort()) {
                case 1: {
                    valueMethod = Method.getMethod((String)"boolean booleanValue()");
                    break;
                }
                case 2: {
                    valueMethod = Method.getMethod((String)"char charValue()");
                    break;
                }
                case 3: {
                    valueMethod = Method.getMethod((String)"byte byteValue()");
                    break;
                }
                case 4: {
                    valueMethod = Method.getMethod((String)"short shortValue()");
                    break;
                }
                case 5: {
                    valueMethod = Method.getMethod((String)"int intValue()");
                    break;
                }
                case 7: {
                    valueMethod = Method.getMethod((String)"long longValue()");
                    break;
                }
                case 8: {
                    valueMethod = Method.getMethod((String)"double doubleValue()");
                    break;
                }
                case 6: {
                    valueMethod = Method.getMethod((String)"float floatValue()");
                    break;
                }
            }
            if (valueMethod != null) {
                methodVisitor.visitMethodInsn(182, internalName, valueMethod.getName(), valueMethod.getDescriptor(), false);
            }
        }
    }

    protected static void pushReturnValue(MethodVisitor methodVisitor, Object type) {
        if (type instanceof Class) {
            Class typeClass = (Class)type;
            if (typeClass.isPrimitive()) {
                Type primitiveType = Type.getType((Class)typeClass);
                switch (primitiveType.getSort()) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        methodVisitor.visitInsn(172);
                        break;
                    }
                    case 0: {
                        methodVisitor.visitInsn(177);
                        break;
                    }
                    case 7: {
                        methodVisitor.visitInsn(173);
                        break;
                    }
                    case 8: {
                        methodVisitor.visitInsn(175);
                        break;
                    }
                    case 6: {
                        methodVisitor.visitInsn(174);
                        break;
                    }
                }
            } else {
                methodVisitor.visitInsn(176);
            }
        } else {
            methodVisitor.visitInsn(176);
        }
    }

    protected static Class getWrapperType(Object type) {
        if (AbstractClassFileWriter.isPrimitive(type)) {
            return ReflectionUtils.getWrapperType((Class)((Class)type));
        }
        return null;
    }

    protected static boolean isPrimitive(Object type) {
        if (type instanceof Class) {
            Class typeClass = (Class)type;
            return typeClass.isPrimitive();
        }
        return false;
    }

    protected static void pushMethodNameAndTypesArguments(GeneratorAdapter methodVisitor, String methodName, Collection<Object> argumentTypes) {
        methodVisitor.visitLdcInsn((Object)methodName);
        int argTypeCount = argumentTypes.size();
        if (!argumentTypes.isEmpty()) {
            AbstractClassFileWriter.pushNewArray(methodVisitor, Class.class, argTypeCount);
            Iterator<Object> argIterator = argumentTypes.iterator();
            for (int i = 0; i < argTypeCount; ++i) {
                AbstractClassFileWriter.pushStoreTypeInArray(methodVisitor, i, argTypeCount, argIterator.next());
            }
        } else {
            AbstractClassFileWriter.pushNewArray(methodVisitor, Class.class, 0);
        }
    }

    protected static void pushNewArray(GeneratorAdapter methodVisitor, Class arrayType, int size) {
        methodVisitor.push(size);
        methodVisitor.visitTypeInsn(189, Type.getInternalName((Class)arrayType));
        if (size > 0) {
            methodVisitor.visitInsn(89);
        }
    }

    protected static void pushStoreStringInArray(GeneratorAdapter methodVisitor, int index, int size, String string) {
        methodVisitor.push(index);
        methodVisitor.push(string);
        methodVisitor.visitInsn(83);
        if (index != size - 1) {
            methodVisitor.dup();
        }
    }

    protected static void pushStoreInArray(GeneratorAdapter methodVisitor, int index, int size, Runnable runnable) {
        methodVisitor.push(index);
        runnable.run();
        methodVisitor.visitInsn(83);
        if (index != size - 1) {
            methodVisitor.dup();
        }
    }

    protected static void pushStoreTypeInArray(GeneratorAdapter methodVisitor, int index, int size, Object type) {
        methodVisitor.push(index);
        if (type instanceof Class) {
            Class typeClass = (Class)type;
            if (typeClass.isPrimitive()) {
                Type wrapperType = Type.getType((Class)ReflectionUtils.getWrapperType((Class)typeClass));
                methodVisitor.visitFieldInsn(178, wrapperType.getInternalName(), "TYPE", Type.getDescriptor(Class.class));
            } else {
                methodVisitor.push(Type.getType((Class)typeClass));
            }
        } else {
            methodVisitor.push(AbstractClassFileWriter.getObjectType(type.toString()));
        }
        methodVisitor.arrayStore(TYPE_CLASS);
        if (index < size - 1) {
            methodVisitor.dup();
        }
    }

    protected Type[] getObjectTypes(Collection types) {
        Type[] converted = new Type[types.size()];
        Iterator iter = types.iterator();
        for (int i = 0; i < converted.length; ++i) {
            Object type = iter.next();
            converted[i] = AbstractClassFileWriter.getObjectType(type);
        }
        return converted;
    }

    protected static Type getObjectType(Object type) {
        if (type instanceof Class) {
            return Type.getType((Class)((Class)type));
        }
        if (type instanceof String) {
            String className = type.toString();
            String internalName = AbstractClassFileWriter.getTypeDescriptor(className);
            return Type.getType((String)internalName);
        }
        throw new IllegalArgumentException("Type reference [" + type + "] should be a Class or a String representing the class name");
    }

    protected static String getTypeDescriptor(String className, String ... genericTypes) {
        if (NAME_TO_TYPE_MAP.containsKey(className)) {
            return NAME_TO_TYPE_MAP.get(className);
        }
        String internalName = AbstractClassFileWriter.getInternalName(className);
        StringBuilder start = className.endsWith("[]") ? new StringBuilder("[L" + internalName) : new StringBuilder('L' + internalName);
        if (genericTypes != null && genericTypes.length > 0) {
            start.append('<');
            for (String genericType : genericTypes) {
                start.append(AbstractClassFileWriter.getTypeDescriptor(genericType));
            }
            start.append('>');
        }
        return start.append(';').toString();
    }

    protected static String getMethodDescriptor(String returnType, String ... argumentTypes) {
        StringBuilder builder = new StringBuilder();
        builder.append('(');
        for (String argumentType : argumentTypes) {
            builder.append(AbstractClassFileWriter.getTypeDescriptor(argumentType));
        }
        builder.append(")");
        builder.append(AbstractClassFileWriter.getTypeDescriptor(returnType));
        return builder.toString();
    }

    protected static String getMethodDescriptor(Object returnType, Collection<Object> argumentTypes) {
        StringBuilder builder = new StringBuilder();
        builder.append('(');
        for (Object argumentType : argumentTypes) {
            builder.append(AbstractClassFileWriter.getTypeDescriptor(argumentType));
        }
        builder.append(")");
        builder.append(AbstractClassFileWriter.getTypeDescriptor(returnType));
        return builder.toString();
    }

    protected static String getMethodSignature(String returnTypeReference, String ... argReferenceTypes) {
        StringBuilder builder = new StringBuilder();
        builder.append('(');
        for (String argumentType : argReferenceTypes) {
            builder.append(argumentType);
        }
        builder.append(")");
        builder.append(returnTypeReference);
        return builder.toString();
    }

    protected static String getConstructorDescriptor(Object ... argumentTypes) {
        return AbstractClassFileWriter.getConstructorDescriptor(Arrays.asList(argumentTypes));
    }

    protected static String getConstructorDescriptor(Collection<Object> argList) {
        StringBuilder builder = new StringBuilder();
        builder.append('(');
        for (Object argumentType : argList) {
            builder.append(AbstractClassFileWriter.getTypeDescriptor(argumentType));
        }
        return builder.append(")V").toString();
    }

    protected void writeClassToDisk(File targetDir, ClassWriter classWriter, String className) throws IOException {
        if (targetDir != null) {
            String fileName = className.replace('.', '/') + ".class";
            File targetFile = new File(targetDir, fileName);
            targetFile.getParentFile().mkdirs();
            try (FileOutputStream outputStream = new FileOutputStream(targetFile);){
                this.writeClassToDisk(outputStream, classWriter);
            }
        }
    }

    protected void writeClassToDisk(OutputStream out, ClassWriter classWriter) throws IOException {
        byte[] bytes = classWriter.toByteArray();
        out.write(bytes);
    }

    protected GeneratorAdapter startConstructor(ClassVisitor classWriter) {
        MethodVisitor defaultConstructor = classWriter.visitMethod(1, CONSTRUCTOR_NAME, DESCRIPTOR_DEFAULT_CONSTRUCTOR, null, null);
        return new GeneratorAdapter(defaultConstructor, 1, CONSTRUCTOR_NAME, DESCRIPTOR_DEFAULT_CONSTRUCTOR);
    }

    protected GeneratorAdapter startConstructor(ClassVisitor classWriter, Object ... argumentTypes) {
        String descriptor = AbstractClassFileWriter.getConstructorDescriptor(argumentTypes);
        return new GeneratorAdapter(classWriter.visitMethod(1, CONSTRUCTOR_NAME, descriptor, null, null), 1, CONSTRUCTOR_NAME, descriptor);
    }

    protected void startClass(ClassVisitor classWriter, String className, Type superType) {
        classWriter.visit(52, 1, className, null, superType.getInternalName(), null);
    }

    protected void startClass(ClassWriter classWriter, String className, Type superType, String genericSignature) {
        classWriter.visit(52, 1, className, genericSignature, superType.getInternalName(), null);
    }

    protected void invokeConstructor(MethodVisitor cv, Class superClass, Class ... argumentTypes) {
        try {
            Type superType = Type.getType((Class)superClass);
            Type superConstructor = Type.getType(superClass.getDeclaredConstructor(argumentTypes));
            cv.visitMethodInsn(183, superType.getInternalName(), CONSTRUCTOR_NAME, superConstructor.getDescriptor(), false);
        }
        catch (NoSuchMethodException e) {
            throw new ClassGenerationException("Micronaut version on compile classpath doesn't match", e);
        }
    }

    protected static void invokeInterfaceStaticMethod(MethodVisitor visitor, Class targetType, Method method) {
        Type type = Type.getType((Class)targetType);
        String owner = type.getSort() == 9 ? type.getDescriptor() : type.getInternalName();
        visitor.visitMethodInsn(184, owner, method.getName(), method.getDescriptor(), true);
    }

    protected GeneratorAdapter startPublicMethodZeroArgs(ClassWriter classWriter, Class returnType, String methodName) {
        Type methodType = Type.getMethodType((Type)Type.getType((Class)returnType), (Type[])new Type[0]);
        return new GeneratorAdapter(classWriter.visitMethod(1, methodName, methodType.getDescriptor(), null, null), 1, methodName, methodType.getDescriptor());
    }

    protected static String getInternalName(String className) {
        String newClassName = className.replace('.', '/');
        if (newClassName.endsWith("[]")) {
            return newClassName.substring(0, newClassName.length() - 2);
        }
        return newClassName;
    }

    protected static String getInternalNameForCast(Object type) {
        if (type instanceof Class) {
            Class typeClass = (Class)type;
            if (typeClass.isPrimitive()) {
                typeClass = ReflectionUtils.getWrapperType((Class)typeClass);
            }
            return Type.getInternalName((Class)typeClass);
        }
        String className = type.toString();
        if (className.endsWith("[]")) {
            return AbstractClassFileWriter.getTypeDescriptor(type);
        }
        return AbstractClassFileWriter.getInternalName(className);
    }

    protected String getClassFileName(String className) {
        return className.replace('.', File.separatorChar) + ".class";
    }

    protected ClassWriterOutputVisitor newClassWriterOutputVisitor(File compilationDir) {
        return new DirectoryClassWriterOutputVisitor(compilationDir);
    }

    protected void returnVoid(GeneratorAdapter overriddenMethodGenerator) {
        overriddenMethodGenerator.pop();
        overriddenMethodGenerator.visitInsn(177);
    }

    protected GeneratorAdapter visitStaticInitializer(ClassVisitor classWriter) {
        MethodVisitor mv = classWriter.visitMethod(8, "<clinit>", DESCRIPTOR_DEFAULT_CONSTRUCTOR, null, null);
        return new GeneratorAdapter(mv, 8, "<clinit>", DESCRIPTOR_DEFAULT_CONSTRUCTOR);
    }

    protected GeneratorAdapter startPublicMethod(ClassWriter writer, String methodName, String returnType, String ... argumentTypes) {
        return new GeneratorAdapter(writer.visitMethod(1, methodName, AbstractClassFileWriter.getMethodDescriptor(returnType, argumentTypes), null, null), 1, methodName, AbstractClassFileWriter.getMethodDescriptor(returnType, argumentTypes));
    }

    protected GeneratorAdapter startProtectedMethod(ClassWriter writer, String methodName, String returnType, String ... argumentTypes) {
        return new GeneratorAdapter(writer.visitMethod(4, methodName, AbstractClassFileWriter.getMethodDescriptor(returnType, argumentTypes), null, null), 4, methodName, AbstractClassFileWriter.getMethodDescriptor(returnType, argumentTypes));
    }

    protected void generateServiceDescriptor(String className, GeneratedFile generatedFile) throws IOException {
        CharSequence contents = generatedFile.getTextContent();
        if (contents != null) {
            String[] entries = contents.toString().split("\\n");
            if (!Arrays.asList(entries).contains(className)) {
                try (BufferedWriter w = new BufferedWriter(generatedFile.openWriter());){
                    w.newLine();
                    w.write(className);
                }
            }
        } else {
            try (BufferedWriter w = new BufferedWriter(generatedFile.openWriter());){
                w.write(className);
            }
        }
    }

    static {
        NAME_TO_TYPE_MAP.put("void", "V");
        NAME_TO_TYPE_MAP.put("boolean", "Z");
        NAME_TO_TYPE_MAP.put("char", "C");
        NAME_TO_TYPE_MAP.put("int", "I");
        NAME_TO_TYPE_MAP.put("byte", "B");
        NAME_TO_TYPE_MAP.put("long", "J");
        NAME_TO_TYPE_MAP.put("double", "D");
        NAME_TO_TYPE_MAP.put("float", "F");
    }
}

