/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.qualifiers;

import io.micronaut.context.Qualifier;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.reflect.GenericTypeUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.BeanType;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class TypeArgumentQualifier<T>
implements Qualifier<T> {
    private static final Logger LOG = LoggerFactory.getLogger(TypeArgumentQualifier.class);
    private final Class[] typeArguments;

    TypeArgumentQualifier(Class ... typeArguments) {
        this.typeArguments = typeArguments;
    }

    @Override
    public <BT extends BeanType<T>> Stream<BT> reduce(Class<T> beanType, Stream<BT> candidates) {
        return candidates.filter(candidate -> {
            if (!beanType.isAssignableFrom(candidate.getBeanType())) {
                return false;
            }
            if (candidate instanceof BeanDefinition) {
                BeanDefinition definition = (BeanDefinition)candidate;
                List<Class> typeArguments = definition.getTypeArguments(beanType).stream().map(Argument::getType).collect(Collectors.toList());
                boolean result = this.areTypesCompatible(typeArguments);
                if (LOG.isTraceEnabled() && !result) {
                    LOG.trace("Bean type {} is not compatible with candidate generic types [{}] of candidate {}", new Object[]{beanType, CollectionUtils.toString(typeArguments), candidate});
                }
                return result;
            }
            if (beanType.isInterface()) {
                Object[] classes = GenericTypeUtils.resolveInterfaceTypeArguments(candidate.getBeanType(), (Class)beanType);
                boolean result = this.areTypesCompatible(Arrays.asList(classes));
                if (LOG.isTraceEnabled() && !result) {
                    LOG.trace("Bean type {} is not compatible with candidate generic types [{}] of candidate {}", new Object[]{beanType, ArrayUtils.toString((Object[])classes), candidate});
                }
                return result;
            }
            Object[] classes = GenericTypeUtils.resolveSuperTypeGenericArguments(candidate.getBeanType(), (Class)beanType);
            boolean result = this.areTypesCompatible(Arrays.asList(classes));
            if (LOG.isTraceEnabled() && !result) {
                LOG.trace("Bean type {} is not compatible with candidate generic types [{}] of candidate {}", new Object[]{beanType, ArrayUtils.toString((Object[])classes), candidate});
            }
            return result;
        });
    }

    public Class[] getTypeArguments() {
        return this.typeArguments;
    }

    protected boolean areTypesCompatible(List<Class> classes) {
        if (classes.size() == 0) {
            return true;
        }
        if (classes.size() != this.typeArguments.length) {
            return false;
        }
        for (int i = 0; i < classes.size(); ++i) {
            Class left = classes.get(i);
            Class right = this.typeArguments[i];
            if (right == Object.class || left == right || left.isAssignableFrom(right)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeArgumentQualifier that = (TypeArgumentQualifier)o;
        return Arrays.equals(this.typeArguments, that.typeArguments);
    }

    public int hashCode() {
        return Arrays.hashCode(this.typeArguments);
    }

    public String toString() {
        return "<" + Arrays.stream(this.typeArguments).map(Class::getSimpleName).collect(Collectors.joining(",")) + ">";
    }
}

