/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.qualifiers;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.BeanType;
import io.micronaut.inject.qualifiers.NameQualifier;
import java.lang.annotation.Annotation;
import java.util.stream.Stream;
import javax.inject.Named;

@Internal
class AnnotationMetadataQualifier<T>
extends NameQualifier<T> {
    private final AnnotationMetadata annotationMetadata;
    private final Class<? extends Annotation> annotationType;
    private final String qualifiedName;

    AnnotationMetadataQualifier(AnnotationMetadata metadata, String name) {
        super(name);
        this.annotationMetadata = metadata;
        this.annotationType = null;
        this.qualifiedName = null;
    }

    AnnotationMetadataQualifier(AnnotationMetadata metadata, Class<? extends Annotation> annotationType) {
        super(annotationType.getSimpleName());
        this.annotationMetadata = metadata;
        this.annotationType = annotationType;
        this.qualifiedName = annotationType.getName();
    }

    @Override
    public <BT extends BeanType<T>> Stream<BT> reduce(Class<T> beanType, Stream<BT> candidates) {
        String v = this.annotationMetadata.getValue(Named.class, String.class).orElse(null);
        if (StringUtils.isNotEmpty((CharSequence)v)) {
            String name = Character.toUpperCase(v.charAt(0)) + v.substring(1);
            return this.reduceByName(beanType, candidates, name);
        }
        String name = this.getName();
        return this.reduceByAnnotation(beanType, candidates, name, this.qualifiedName);
    }

    @Override
    public String toString() {
        return this.annotationType == null ? super.toString() : "@" + this.annotationType.getSimpleName();
    }
}

