/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.annotation;

import io.micronaut.core.annotation.AnnotationClassValue;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationUtil;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.value.ConvertibleValues;
import io.micronaut.core.reflect.ClassLoadingReporter;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.core.value.OptionalValues;
import io.micronaut.inject.annotation.AbstractAnnotationMetadata;
import io.micronaut.inject.annotation.AnnotationMetadataSupport;
import java.lang.annotation.Annotation;
import java.lang.annotation.Repeatable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;

@Internal
public class DefaultAnnotationMetadata
extends AbstractAnnotationMetadata
implements AnnotationMetadata,
Cloneable {
    Map<String, Map<CharSequence, Object>> declaredAnnotations;
    Map<String, Map<CharSequence, Object>> allAnnotations;
    Map<String, Map<CharSequence, Object>> declaredStereotypes;
    Map<String, Map<CharSequence, Object>> allStereotypes;
    Map<String, List<String>> annotationsByStereotype;
    Map<String, Map<CharSequence, Object>> annotationDefaultValues;
    private Map<String, String> repeated = null;
    private Map<Class, List> annotationValuesByType = new HashMap<Class, List>();

    @Internal
    protected DefaultAnnotationMetadata() {
    }

    @Internal
    public DefaultAnnotationMetadata(@Nullable Map<String, Map<CharSequence, Object>> declaredAnnotations, @Nullable Map<String, Map<CharSequence, Object>> declaredStereotypes, @Nullable Map<String, Map<CharSequence, Object>> allStereotypes, @Nullable Map<String, Map<CharSequence, Object>> allAnnotations, @Nullable Map<String, List<String>> annotationsByStereotype) {
        super(declaredAnnotations, allAnnotations);
        this.declaredAnnotations = declaredAnnotations;
        this.declaredStereotypes = declaredStereotypes;
        this.allStereotypes = allStereotypes;
        this.allAnnotations = allAnnotations;
        this.annotationsByStereotype = annotationsByStereotype;
        if (ClassLoadingReporter.isReportingEnabled() && allAnnotations != null) {
            for (String annotationName : allAnnotations.keySet()) {
                ClassUtils.forName((String)annotationName, (ClassLoader)DefaultAnnotationMetadata.class.getClassLoader()).ifPresent(ClassLoadingReporter::reportPresent);
            }
        }
    }

    public <T> Optional<T> getValue(Class<? extends Annotation> annotation, String member, Class<T> requiredType) {
        boolean isRepeatable;
        Repeatable repeatable = annotation.getAnnotation(Repeatable.class);
        boolean bl = isRepeatable = repeatable != null;
        if (isRepeatable) {
            List<AnnotationValue<? extends Annotation>> values = this.getAnnotationValuesByType(annotation);
            if (!values.isEmpty()) {
                return values.iterator().next().get((CharSequence)member, requiredType);
            }
            return Optional.empty();
        }
        return this.getValue(annotation.getName(), member, requiredType);
    }

    public <T> Optional<T> getValue(String annotation, String member, Class<T> requiredType) {
        Optional resolved = Optional.empty();
        if (this.allAnnotations != null && StringUtils.isNotEmpty((CharSequence)annotation)) {
            Map<CharSequence, Object> values = this.allAnnotations.get(annotation);
            if (values != null) {
                resolved = ConversionService.SHARED.convert(values.get(member), requiredType);
            } else if (this.allStereotypes != null && (values = this.allStereotypes.get(annotation)) != null) {
                resolved = ConversionService.SHARED.convert(values.get(member), requiredType);
            }
        }
        if (!resolved.isPresent() && this.hasStereotype(annotation)) {
            return this.getDefaultValue(annotation, member, requiredType);
        }
        return resolved;
    }

    public <T> Optional<T> getDefaultValue(String annotation, String member, Class<T> requiredType) {
        Map<String, Object> defaultValues = AnnotationMetadataSupport.getDefaultValues(annotation);
        if (defaultValues.containsKey(member)) {
            return ConversionService.SHARED.convert(defaultValues.get(member), requiredType);
        }
        return Optional.empty();
    }

    public <T extends Annotation> List<AnnotationValue<T>> getAnnotationValuesByType(Class<T> annotationType) {
        if (annotationType != null) {
            return this.annotationValuesByType.computeIfAbsent(annotationType, aClass -> {
                List results = this.resolveAnnotationValuesByType(annotationType, this.allAnnotations, this.allStereotypes);
                if (results != null) {
                    return results;
                }
                return Collections.emptyList();
            });
        }
        return Collections.emptyList();
    }

    public <T extends Annotation> List<AnnotationValue<T>> getDeclaredAnnotationValuesByType(Class<T> annotationType) {
        Map<String, Map<CharSequence, Object>> sourceStereotypes;
        Map<String, Map<CharSequence, Object>> sourceAnnotations;
        List<AnnotationValue<T>> results;
        if (annotationType != null && (results = this.resolveAnnotationValuesByType(annotationType, sourceAnnotations = this.declaredAnnotations, sourceStereotypes = this.declaredStereotypes)) != null) {
            return results;
        }
        return Collections.emptyList();
    }

    public <T extends Annotation> T[] synthesizeAnnotationsByType(Class<T> annotationClass) {
        if (annotationClass != null) {
            List<AnnotationValue<T>> values = this.getAnnotationValuesByType(annotationClass);
            return (Annotation[])values.stream().map(entries -> AnnotationMetadataSupport.buildAnnotation(annotationClass, (ConvertibleValues<Object>)entries.getConvertibleValues())).toArray(value -> (Annotation[])Array.newInstance(annotationClass, value));
        }
        return AnnotationUtil.ZERO_ANNOTATIONS;
    }

    public <T extends Annotation> T[] synthesizeDeclaredAnnotationsByType(Class<T> annotationClass) {
        if (annotationClass != null) {
            List<AnnotationValue<T>> values = this.getAnnotationValuesByType(annotationClass);
            return (Annotation[])values.stream().map(entries -> AnnotationMetadataSupport.buildAnnotation(annotationClass, (ConvertibleValues<Object>)entries.getConvertibleValues())).toArray(value -> (Annotation[])Array.newInstance(annotationClass, value));
        }
        return AnnotationUtil.ZERO_ANNOTATIONS;
    }

    public <T> Optional<T> getDefaultValue(Class<? extends Annotation> annotation, String member, Class<T> requiredType) {
        Map<String, Object> defaultValues = AnnotationMetadataSupport.getDefaultValues(annotation);
        if (defaultValues.containsKey(member)) {
            return ConversionService.SHARED.convert(defaultValues.get(member), requiredType);
        }
        return Optional.empty();
    }

    public boolean isEmpty() {
        return this.allAnnotations == null || this.allAnnotations.isEmpty();
    }

    public boolean hasDeclaredAnnotation(String annotation) {
        return this.declaredAnnotations != null && StringUtils.isNotEmpty((CharSequence)annotation) && this.declaredAnnotations.containsKey(annotation);
    }

    public boolean hasAnnotation(String annotation) {
        return this.hasDeclaredAnnotation(annotation) || this.allAnnotations != null && StringUtils.isNotEmpty((CharSequence)annotation) && this.allAnnotations.keySet().contains(annotation);
    }

    public boolean hasStereotype(String annotation) {
        return this.hasAnnotation(annotation) || this.allStereotypes != null && StringUtils.isNotEmpty((CharSequence)annotation) && this.allStereotypes.keySet().contains(annotation);
    }

    public boolean hasDeclaredStereotype(String annotation) {
        return this.hasDeclaredAnnotation(annotation) || this.declaredStereotypes != null && StringUtils.isNotEmpty((CharSequence)annotation) && this.declaredStereotypes.containsKey(annotation);
    }

    public List<String> getAnnotationNamesByStereotype(String stereotype) {
        List<String> annotations;
        if (this.annotationsByStereotype != null && (annotations = this.annotationsByStereotype.get(stereotype)) != null) {
            return Collections.unmodifiableList(annotations);
        }
        if (this.allAnnotations != null && this.allAnnotations.containsKey(stereotype)) {
            return StringUtils.internListOf((Object[])new Object[]{stereotype});
        }
        if (this.declaredAnnotations != null && this.declaredAnnotations.containsKey(stereotype)) {
            return StringUtils.internListOf((Object[])new Object[]{stereotype});
        }
        return Collections.emptyList();
    }

    public Set<String> getAnnotationNames() {
        if (this.allAnnotations != null) {
            return this.allAnnotations.keySet();
        }
        return Collections.emptySet();
    }

    public Set<String> getDeclaredAnnotationNames() {
        if (this.declaredAnnotations != null) {
            return this.declaredAnnotations.keySet();
        }
        return Collections.emptySet();
    }

    public List<String> getDeclaredAnnotationNamesByStereotype(String stereotype) {
        List<String> annotations;
        if (this.annotationsByStereotype != null && (annotations = this.annotationsByStereotype.get(stereotype)) != null) {
            annotations = new ArrayList<String>(annotations);
            if (this.declaredAnnotations != null) {
                annotations.removeIf(s -> !this.declaredAnnotations.containsKey(s));
                return Collections.unmodifiableList(annotations);
            }
            return Collections.emptyList();
        }
        if (this.declaredAnnotations != null && this.declaredAnnotations.containsKey(stereotype)) {
            return StringUtils.internListOf((Object[])new Object[]{stereotype});
        }
        return Collections.emptyList();
    }

    public Optional<Class<? extends Annotation>> getAnnotationType(String name) {
        return AnnotationMetadataSupport.getAnnotationType(name);
    }

    public <T extends Annotation> Optional<AnnotationValue<T>> findAnnotation(String annotation) {
        if (this.allAnnotations != null && StringUtils.isNotEmpty((CharSequence)annotation)) {
            Map<CharSequence, Object> values = this.allAnnotations.get(annotation);
            if (values != null) {
                return Optional.of(new AnnotationValue(annotation, values, AnnotationMetadataSupport.getDefaultValues(annotation)));
            }
            if (this.allStereotypes != null && (values = this.allStereotypes.get(annotation)) != null) {
                return Optional.of(new AnnotationValue(annotation, values, AnnotationMetadataSupport.getDefaultValues(annotation)));
            }
        }
        return Optional.empty();
    }

    public <T extends Annotation> Optional<AnnotationValue<T>> findDeclaredAnnotation(String annotation) {
        if (this.declaredAnnotations != null && StringUtils.isNotEmpty((CharSequence)annotation)) {
            Map<CharSequence, Object> values = this.declaredAnnotations.get(annotation);
            if (values != null) {
                return Optional.of(new AnnotationValue(annotation, values, AnnotationMetadataSupport.getDefaultValues(annotation)));
            }
            if (this.declaredStereotypes != null && (values = this.declaredStereotypes.get(annotation)) != null) {
                return Optional.of(new AnnotationValue(annotation, values, AnnotationMetadataSupport.getDefaultValues(annotation)));
            }
        }
        return Optional.empty();
    }

    public <T> OptionalValues<T> getValues(String annotation, Class<T> valueType) {
        if (this.allAnnotations != null && StringUtils.isNotEmpty((CharSequence)annotation)) {
            Map<CharSequence, Object> values = this.allAnnotations.get(annotation);
            if (values != null) {
                return OptionalValues.of(valueType, values);
            }
            values = this.allStereotypes.get(annotation);
            if (values != null) {
                return OptionalValues.of(valueType, values);
            }
        }
        return OptionalValues.empty();
    }

    public AnnotationMetadata clone() {
        return new DefaultAnnotationMetadata(this.declaredAnnotations != null ? new HashMap<String, Map<CharSequence, Object>>(this.declaredAnnotations) : null, this.declaredStereotypes != null ? new HashMap<String, Map<CharSequence, Object>>(this.declaredStereotypes) : null, this.allStereotypes != null ? new HashMap<String, Map<CharSequence, Object>>(this.allStereotypes) : null, this.allAnnotations != null ? new HashMap<String, Map<CharSequence, Object>>(this.allAnnotations) : null, (Map<String, List<String>>)(this.annotationsByStereotype != null ? new HashMap<String, List<String>>(this.annotationsByStereotype) : null));
    }

    protected final void addAnnotation(String annotation, Map<CharSequence, Object> values) {
        if (annotation != null) {
            String repeatedName = this.getRepeatedName(annotation);
            if (repeatedName != null) {
                Object v = values.get("value");
                if (v instanceof AnnotationValue[]) {
                    AnnotationValue[] avs;
                    for (AnnotationValue av : avs = (AnnotationValue[])v) {
                        this.addRepeatable(annotation, av);
                    }
                } else if (v instanceof Iterable) {
                    Iterable i = (Iterable)v;
                    for (Object o : i) {
                        if (!(o instanceof AnnotationValue)) continue;
                        this.addRepeatable(annotation, (AnnotationValue)o);
                    }
                }
            } else {
                Map<String, Map<CharSequence, Object>> allAnnotations = this.getAllAnnotations();
                this.addAnnotation(annotation, values, null, allAnnotations, false);
            }
        }
    }

    protected final void addDefaultAnnotationValues(String annotation, Map<CharSequence, Object> values) {
        if (annotation != null) {
            Map<String, Map<CharSequence, Object>> annotationDefaults = this.annotationDefaultValues;
            if (annotationDefaults == null) {
                annotationDefaults = this.annotationDefaultValues = new HashMap<String, Map<CharSequence, Object>>();
            }
            this.putValues(annotation, values, annotationDefaults);
        }
    }

    @Internal
    protected static boolean areAnnotationDefaultsRegistered(String annotation) {
        return AnnotationMetadataSupport.hasDefaultValues(annotation);
    }

    @Internal
    protected static void registerAnnotationDefaults(String annotation, Map<String, Object> defaultValues) {
        AnnotationMetadataSupport.registerDefaultValues(annotation, defaultValues);
    }

    @Internal
    protected static void registerAnnotationDefaults(AnnotationClassValue<?> annotation, Map<String, Object> defaultValues) {
        AnnotationMetadataSupport.registerDefaultValues(annotation, defaultValues);
    }

    protected final void addRepeatable(String annotationName, AnnotationValue annotationValue) {
        if (StringUtils.isNotEmpty((CharSequence)annotationName) && annotationValue != null) {
            Map<String, Map<CharSequence, Object>> allAnnotations = this.getAllAnnotations();
            this.addRepeatableInternal(annotationName, annotationValue, allAnnotations);
        }
    }

    protected void addRepeatableStereotype(List<String> parents, String stereotype, AnnotationValue annotationValue) {
        Map<String, Map<CharSequence, Object>> allStereotypes = this.getAllStereotypes();
        List<String> annotationList = this.getAnnotationsByStereotypeInternal(stereotype);
        for (String parentAnnotation : parents) {
            if (annotationList.contains(parentAnnotation)) continue;
            annotationList.add(parentAnnotation);
        }
        this.addRepeatableInternal(stereotype, annotationValue, allStereotypes);
    }

    protected void addDeclaredRepeatableStereotype(List<String> parents, String stereotype, AnnotationValue annotationValue) {
        Map<String, Map<CharSequence, Object>> declaredStereotypes = this.getDeclaredStereotypesInternal();
        List<String> annotationList = this.getAnnotationsByStereotypeInternal(stereotype);
        for (String parentAnnotation : parents) {
            if (annotationList.contains(parentAnnotation)) continue;
            annotationList.add(parentAnnotation);
        }
        this.addRepeatableInternal(stereotype, annotationValue, declaredStereotypes);
        this.addRepeatableInternal(stereotype, annotationValue, this.getAllStereotypes());
    }

    protected final void addDeclaredRepeatable(String annotationName, AnnotationValue annotationValue) {
        if (StringUtils.isNotEmpty((CharSequence)annotationName) && annotationValue != null) {
            Map<String, Map<CharSequence, Object>> allAnnotations = this.getDeclaredAnnotationsInternal();
            this.addRepeatableInternal(annotationName, annotationValue, allAnnotations);
            this.addRepeatable(annotationName, annotationValue);
        }
    }

    protected final void addStereotype(List<String> parentAnnotations, String stereotype, Map<CharSequence, Object> values) {
        if (stereotype != null) {
            String repeatedName = this.getRepeatedName(stereotype);
            if (repeatedName != null) {
                Object v = values.get("value");
                if (v instanceof AnnotationValue[]) {
                    AnnotationValue[] avs;
                    for (AnnotationValue av : avs = (AnnotationValue[])v) {
                        this.addRepeatableStereotype(parentAnnotations, stereotype, av);
                    }
                } else if (v instanceof Iterable) {
                    Iterable i = (Iterable)v;
                    for (Object o : i) {
                        if (!(o instanceof AnnotationValue)) continue;
                        this.addRepeatableStereotype(parentAnnotations, stereotype, (AnnotationValue)o);
                    }
                }
            } else {
                Map<String, Map<CharSequence, Object>> allStereotypes = this.getAllStereotypes();
                List<String> annotationList = this.getAnnotationsByStereotypeInternal(stereotype);
                for (String parentAnnotation : parentAnnotations) {
                    if (annotationList.contains(parentAnnotation)) continue;
                    annotationList.add(parentAnnotation);
                }
                this.addAnnotation(stereotype, values, null, allStereotypes, false);
            }
        }
    }

    protected final void addDeclaredStereotype(List<String> parentAnnotations, String stereotype, Map<CharSequence, Object> values) {
        if (stereotype != null) {
            String repeatedName = this.getRepeatedName(stereotype);
            if (repeatedName != null) {
                Object v = values.get("value");
                if (v instanceof AnnotationValue[]) {
                    AnnotationValue[] avs;
                    for (AnnotationValue av : avs = (AnnotationValue[])v) {
                        this.addDeclaredRepeatableStereotype(parentAnnotations, stereotype, av);
                    }
                } else if (v instanceof Iterable) {
                    Iterable i = (Iterable)v;
                    for (Object o : i) {
                        if (!(o instanceof AnnotationValue)) continue;
                        this.addDeclaredRepeatableStereotype(parentAnnotations, stereotype, (AnnotationValue)o);
                    }
                }
            } else {
                Map<String, Map<CharSequence, Object>> declaredStereotypes = this.getDeclaredStereotypesInternal();
                Map<String, Map<CharSequence, Object>> allStereotypes = this.getAllStereotypes();
                List<String> annotationList = this.getAnnotationsByStereotypeInternal(stereotype);
                for (String parentAnnotation : parentAnnotations) {
                    if (annotationList.contains(parentAnnotation)) continue;
                    annotationList.add(parentAnnotation);
                }
                this.addAnnotation(stereotype, values, declaredStereotypes, allStereotypes, true);
            }
        }
    }

    protected void addDeclaredAnnotation(String annotation, Map<CharSequence, Object> values) {
        if (annotation != null) {
            String repeatedName = this.getRepeatedName(annotation);
            if (repeatedName != null) {
                Object v = values.get("value");
                if (v instanceof AnnotationValue[]) {
                    AnnotationValue[] avs;
                    for (AnnotationValue av : avs = (AnnotationValue[])v) {
                        this.addDeclaredRepeatable(annotation, av);
                    }
                } else if (v instanceof Iterable) {
                    Iterable i = (Iterable)v;
                    for (Object o : i) {
                        if (!(o instanceof AnnotationValue)) continue;
                        this.addDeclaredRepeatable(annotation, (AnnotationValue)o);
                    }
                }
            } else {
                Map<String, Map<CharSequence, Object>> declaredAnnotations = this.getDeclaredAnnotationsInternal();
                Map<String, Map<CharSequence, Object>> allAnnotations = this.getAllAnnotations();
                this.addAnnotation(annotation, values, declaredAnnotations, allAnnotations, true);
            }
        }
    }

    @Internal
    void dump() {
        System.out.println("declaredAnnotations = " + this.declaredAnnotations);
        System.out.println("declaredStereotypes = " + this.declaredStereotypes);
        System.out.println("allAnnotations = " + this.allAnnotations);
        System.out.println("allStereotypes = " + this.allStereotypes);
        System.out.println("annotationsByStereotype = " + this.annotationsByStereotype);
    }

    private <T extends Annotation> List<AnnotationValue<T>> resolveAnnotationValuesByType(Class<T> annotationType, Map<String, Map<CharSequence, Object>> sourceAnnotations, Map<String, Map<CharSequence, Object>> sourceStereotypes) {
        Class<? extends Annotation> repeatableType;
        Repeatable repeatable = annotationType.getAnnotation(Repeatable.class);
        if (repeatable != null && this.hasStereotype(repeatableType = repeatable.value())) {
            Map<CharSequence, Object> values;
            ArrayList<AnnotationValue<T>> results = new ArrayList<AnnotationValue<T>>();
            if (sourceAnnotations != null) {
                values = sourceAnnotations.get(repeatableType.getName());
                this.addAnnotationValuesFromData(results, values);
            }
            if (sourceStereotypes != null) {
                values = sourceStereotypes.get(repeatableType.getName());
                this.addAnnotationValuesFromData(results, values);
            }
            return results;
        }
        return null;
    }

    private void addAnnotation(String annotation, Map<CharSequence, Object> values, Map<String, Map<CharSequence, Object>> declaredAnnotations, Map<String, Map<CharSequence, Object>> allAnnotations, boolean isDeclared) {
        if (isDeclared && declaredAnnotations != null) {
            this.putValues(annotation, values, declaredAnnotations);
        }
        this.putValues(annotation, values, allAnnotations);
    }

    private void putValues(String annotation, Map<CharSequence, Object> values, Map<String, Map<CharSequence, Object>> currentAnnotationValues) {
        Map<CharSequence, Object> existing = currentAnnotationValues.get(annotation);
        boolean hasValues = CollectionUtils.isNotEmpty(values);
        if (existing != null && hasValues) {
            if (existing.isEmpty()) {
                existing = new LinkedHashMap<CharSequence, Object>();
                currentAnnotationValues.put(annotation, existing);
            }
            for (CharSequence key : values.keySet()) {
                if (existing.containsKey(key)) continue;
                existing.put(key, values.get(key));
            }
        } else {
            if (!hasValues) {
                existing = existing == null ? Collections.emptyMap() : existing;
            } else {
                existing = new LinkedHashMap<CharSequence, Object>(values.size());
                existing.putAll(values);
            }
            currentAnnotationValues.put(annotation, existing);
        }
    }

    private ConvertibleValues<Object> convertibleValuesOf(Map<CharSequence, Object> values) {
        return ConvertibleValues.of(values);
    }

    private Map<String, Map<CharSequence, Object>> getAllStereotypes() {
        Map<String, Map<CharSequence, Object>> stereotypes = this.allStereotypes;
        if (stereotypes == null) {
            this.allStereotypes = stereotypes = new HashMap<String, Map<CharSequence, Object>>(3);
        }
        return stereotypes;
    }

    private Map<String, Map<CharSequence, Object>> getDeclaredStereotypesInternal() {
        Map<String, Map<CharSequence, Object>> stereotypes = this.declaredStereotypes;
        if (stereotypes == null) {
            this.declaredStereotypes = stereotypes = new HashMap<String, Map<CharSequence, Object>>(3);
        }
        return stereotypes;
    }

    private Map<String, Map<CharSequence, Object>> getAllAnnotations() {
        Map<String, Map<CharSequence, Object>> annotations = this.allAnnotations;
        if (annotations == null) {
            this.allAnnotations = annotations = new HashMap<String, Map<CharSequence, Object>>(3);
        }
        return annotations;
    }

    private Map<String, Map<CharSequence, Object>> getDeclaredAnnotationsInternal() {
        Map<String, Map<CharSequence, Object>> annotations = this.declaredAnnotations;
        if (annotations == null) {
            this.declaredAnnotations = annotations = new HashMap<String, Map<CharSequence, Object>>(3);
        }
        return annotations;
    }

    private List<String> getAnnotationsByStereotypeInternal(String stereotype) {
        return this.getAnnotationsByStereotypeInternal().computeIfAbsent(stereotype, s -> new ArrayList());
    }

    private String getRepeatedName(String annotation) {
        if (this.repeated != null) {
            return this.repeated.get(annotation);
        }
        return null;
    }

    private Map<String, List<String>> getAnnotationsByStereotypeInternal() {
        Map<String, List<String>> annotations = this.annotationsByStereotype;
        if (annotations == null) {
            this.annotationsByStereotype = annotations = new HashMap<String, List<String>>(3);
        }
        return annotations;
    }

    private void addRepeatableInternal(String annotationName, AnnotationValue annotationValue, Map<String, Map<CharSequence, Object>> allAnnotations) {
        this.addRepeatableInternal(annotationName, "value", annotationValue, allAnnotations);
    }

    private void addRepeatableInternal(String annotationName, String member, AnnotationValue annotationValue, Map<String, Map<CharSequence, Object>> allAnnotations) {
        if (this.repeated == null) {
            this.repeated = new HashMap<String, String>(2);
        }
        this.repeated.put(annotationName, annotationValue.getAnnotationName());
        Map values = allAnnotations.computeIfAbsent(annotationName, s -> new HashMap());
        Object v = values.get(member);
        if (v != null) {
            if (v.getClass().isArray()) {
                Object[] array = (Object[])v;
                ArrayList<Object> newValues = new ArrayList<Object>(array.length + 1);
                newValues.addAll(Arrays.asList(array));
                newValues.add(annotationValue);
                values.put(member, newValues);
            } else if (v instanceof Collection) {
                ((Collection)v).add(annotationValue);
            }
        } else {
            ArrayList<AnnotationValue> newValues = new ArrayList<AnnotationValue>(2);
            newValues.add(annotationValue);
            values.put(member, newValues);
        }
    }

    @Internal
    public static AnnotationMetadata mutateMember(AnnotationMetadata annotationMetadata, String annotationName, String member, Object value) {
        return DefaultAnnotationMetadata.mutateMember(annotationMetadata, annotationName, Collections.singletonMap(member, value));
    }

    @Internal
    public static AnnotationMetadata mutateMember(AnnotationMetadata annotationMetadata, final String annotationName, final Map<CharSequence, Object> members) {
        if (StringUtils.isEmpty((CharSequence)annotationName)) {
            throw new IllegalArgumentException("Argument [annotationName] cannot be blank");
        }
        if (!members.isEmpty()) {
            for (Map.Entry<CharSequence, Object> entry : members.entrySet()) {
                if (StringUtils.isEmpty((CharSequence)entry.getKey())) {
                    throw new IllegalArgumentException("Argument [members] cannot have a blank key");
                }
                if (entry.getValue() != null) continue;
                throw new IllegalArgumentException("Argument [members] cannot have a null value. Key [" + entry.getKey() + "]");
            }
        }
        if (!(annotationMetadata instanceof DefaultAnnotationMetadata)) {
            return new DefaultAnnotationMetadata(){
                {
                    this.addDeclaredAnnotation(annotationName, members);
                }
            };
        }
        DefaultAnnotationMetadata defaultMetadata = (DefaultAnnotationMetadata)annotationMetadata;
        defaultMetadata = (DefaultAnnotationMetadata)defaultMetadata.clone();
        defaultMetadata.addDeclaredAnnotation(annotationName, members);
        return defaultMetadata;
    }

    static {
        ConversionService.SHARED.addConverter(AnnotationValue.class, Annotation.class, (object, targetType, context) -> {
            Optional annotationClass = ClassUtils.forName((String)object.getAnnotationName(), (ClassLoader)targetType.getClassLoader());
            return annotationClass.map(aClass -> AnnotationMetadataSupport.buildAnnotation(aClass, (ConvertibleValues<Object>)ConvertibleValues.of((Map)object.getValues())));
        });
        ConversionService.SHARED.addConverter(AnnotationValue[].class, Object[].class, (object, targetType, context) -> {
            ArrayList result = new ArrayList();
            Class annotationClass = null;
            for (AnnotationValue annotationValue : object) {
                if (annotationClass == null) {
                    Optional aClass = ClassUtils.forName((String)annotationValue.getAnnotationName(), (ClassLoader)targetType.getClassLoader());
                    if (!aClass.isPresent()) break;
                    annotationClass = (Class)aClass.get();
                }
                Object annotation = AnnotationMetadataSupport.buildAnnotation(annotationClass, (ConvertibleValues<Object>)ConvertibleValues.of((Map)annotationValue.getValues()));
                result.add(annotation);
            }
            if (!result.isEmpty()) {
                return Optional.of(result.toArray((Object[])Array.newInstance(annotationClass, result.size())));
            }
            return Optional.empty();
        });
    }
}

