/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context.env;

import io.micronaut.context.annotation.Property;
import io.micronaut.context.env.DefaultPropertyPlaceholderResolver;
import io.micronaut.context.env.PropertyPlaceholderResolver;
import io.micronaut.context.env.PropertySource;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.format.MapFormat;
import io.micronaut.core.io.socket.SocketUtils;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.naming.conventions.StringConvention;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.core.value.MapPropertyResolver;
import io.micronaut.core.value.PropertyResolver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertySourcePropertyResolver
implements PropertyResolver {
    private static final Logger LOG = LoggerFactory.getLogger(PropertySourcePropertyResolver.class);
    private static final Pattern RANDOM_PATTERN = Pattern.compile("\\$\\{\\s?random\\.(\\S+?)\\}");
    protected final ConversionService<?> conversionService;
    protected final PropertyPlaceholderResolver propertyPlaceholderResolver;
    protected final Map<String, PropertySource> propertySources = new ConcurrentHashMap<String, PropertySource>(10);
    protected final Map<String, Object>[] catalog = new Map[57];
    private final Random random = new Random();
    private final Map<String, Boolean> containsCache = new ConcurrentHashMap<String, Boolean>(20);
    private final Map<String, Optional<?>> resolvedValueCache = new ConcurrentHashMap(20);

    public PropertySourcePropertyResolver(ConversionService<?> conversionService) {
        this.conversionService = conversionService;
        this.propertyPlaceholderResolver = new DefaultPropertyPlaceholderResolver(this);
    }

    public PropertySourcePropertyResolver() {
        this(ConversionService.SHARED);
    }

    public PropertySourcePropertyResolver(PropertySource ... propertySources) {
        this(ConversionService.SHARED);
        if (propertySources != null) {
            for (PropertySource propertySource : propertySources) {
                this.addPropertySource(propertySource);
            }
        }
    }

    public PropertySourcePropertyResolver addPropertySource(@Nullable PropertySource propertySource) {
        if (propertySource != null) {
            this.propertySources.put(propertySource.getName(), propertySource);
            this.processPropertySource(propertySource, propertySource.getConvention());
        }
        return this;
    }

    public PropertySourcePropertyResolver addPropertySource(String name, @Nullable Map<String, ? super Object> values) {
        if (CollectionUtils.isNotEmpty(values)) {
            return this.addPropertySource(PropertySource.of(name, values));
        }
        return this;
    }

    public boolean containsProperty(@Nullable String name) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            return false;
        }
        Boolean result = this.containsCache.get(name);
        if (result == null) {
            Map<String, Object> entries = this.resolveEntriesForKey(name, false);
            result = entries == null ? Boolean.valueOf(false) : Boolean.valueOf(entries.containsKey(name = this.trimIndex(name)) || entries.containsKey(this.normalizeName(name)));
            this.containsCache.put(name, result);
        }
        return result;
    }

    public boolean containsProperties(@Nullable String name) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            return false;
        }
        Map<String, Object> entries = this.resolveEntriesForKey(name, false);
        if (entries == null) {
            return false;
        }
        if (entries.containsKey(name = this.trimIndex(name)) || entries.containsKey(this.normalizeName(name))) {
            return true;
        }
        String finalName = name + ".";
        return entries.keySet().stream().anyMatch(key -> key.startsWith(finalName));
    }

    public <T> Optional<T> getProperty(@Nullable String name, ArgumentConversionContext<T> conversionContext) {
        boolean cacheableType;
        if (StringUtils.isEmpty((CharSequence)name)) {
            return Optional.empty();
        }
        Class requiredType = conversionContext.getArgument().getType();
        boolean bl = cacheableType = requiredType == Boolean.class || requiredType == String.class;
        if (cacheableType && this.resolvedValueCache.containsKey(name)) {
            return this.resolvedValueCache.get(name);
        }
        Map<String, Object> entries = this.resolveEntriesForKey(name, false);
        if (entries != null) {
            int i;
            Object value = entries.get(name);
            if (value == null) {
                value = entries.get(this.normalizeName(name));
            }
            if (value == null && (i = name.indexOf(91)) > -1 && name.endsWith("]")) {
                String newKey = name.substring(0, i);
                value = entries.get(newKey);
                if (value != null) {
                    String index = name.substring(i + 1, name.length() - 1);
                    if (StringUtils.isNotEmpty((CharSequence)index)) {
                        if (value instanceof List) {
                            try {
                                value = ((List)value).get(Integer.valueOf(index));
                            }
                            catch (NumberFormatException numberFormatException) {}
                        } else if (value instanceof Map) {
                            try {
                                value = ((Map)value).get(index);
                            }
                            catch (NumberFormatException numberFormatException) {}
                        }
                    }
                } else {
                    String index = name.substring(i + 1, name.length() - 1);
                    if (StringUtils.isNotEmpty((CharSequence)index)) {
                        String subKey = newKey + '.' + index;
                        value = entries.get(subKey);
                    }
                }
            }
            if (value != null) {
                value = this.resolvePlaceHoldersIfNecessary(value);
                Optional converted = this.conversionService.convert(value, conversionContext);
                if (LOG.isTraceEnabled()) {
                    if (converted.isPresent()) {
                        LOG.trace("Resolved value [{}] for property: {}", converted.get(), (Object)name);
                    } else {
                        LOG.trace("Resolved value [{}] cannot be converted to type [{}] for property: {}", new Object[]{value, conversionContext.getArgument(), name});
                    }
                }
                if (cacheableType) {
                    this.resolvedValueCache.put(name, converted);
                }
                return converted;
            }
            if (cacheableType) {
                Optional e = Optional.empty();
                this.resolvedValueCache.put(name, e);
                return e;
            }
            if (Properties.class.isAssignableFrom(requiredType)) {
                Properties properties = this.resolveSubProperties(name, entries, conversionContext);
                return Optional.of(properties);
            }
            if (Map.class.isAssignableFrom(requiredType)) {
                Map<String, Object> subMap = this.resolveSubMap(name, entries, conversionContext);
                return this.conversionService.convert(subMap, requiredType, conversionContext);
            }
            if (PropertyResolver.class.isAssignableFrom(requiredType)) {
                Map<String, Object> subMap = this.resolveSubMap(name, entries, conversionContext);
                return Optional.of(new MapPropertyResolver(subMap, this.conversionService));
            }
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("No value found for property: {}", (Object)name);
        }
        if (Properties.class.isAssignableFrom(requiredType = conversionContext.getArgument().getType())) {
            return Optional.of(new Properties());
        }
        if (Map.class.isAssignableFrom(requiredType)) {
            return Optional.of(Collections.emptyMap());
        }
        return Optional.empty();
    }

    public Map<String, Object> getAllProperties() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Arrays.stream(this.catalog).filter(Objects::nonNull).map(Map::entrySet).flatMap(Collection::stream).forEach(entry -> {
            String k = (String)entry.getKey();
            Object value = this.resolvePlaceHoldersIfNecessary(entry.getValue());
            Map finalMap = map;
            int index = k.indexOf(46);
            if (index != -1) {
                String[] keys = k.split("\\.");
                for (int i = 0; i < keys.length - 1; ++i) {
                    Object next;
                    if (!finalMap.containsKey(keys[i])) {
                        finalMap.put(keys[i], new HashMap());
                    }
                    if (!((next = finalMap.get(keys[i])) instanceof Map)) continue;
                    finalMap = (Map)next;
                }
                finalMap.put(keys[keys.length - 1], value);
            } else {
                finalMap.put(k, value);
            }
        });
        return map;
    }

    protected Properties resolveSubProperties(String name, Map<String, Object> entries, ArgumentConversionContext<?> conversionContext) {
        Properties properties = new Properties();
        AnnotationMetadata annotationMetadata = conversionContext.getAnnotationMetadata();
        StringConvention keyConvention = annotationMetadata.getValue(MapFormat.class, "keyFormat", StringConvention.class).orElse(StringConvention.RAW);
        String prefix = name + '.';
        entries.entrySet().stream().filter(map -> ((String)map.getKey()).startsWith(prefix)).forEach(entry -> {
            Object value = entry.getValue();
            if (value != null) {
                String key = ((String)entry.getKey()).substring(prefix.length());
                key = keyConvention.format(key);
                properties.put(key, this.resolvePlaceHoldersIfNecessary(value.toString()));
            }
        });
        return properties;
    }

    protected Map<String, Object> resolveSubMap(String name, Map<String, Object> entries, ArgumentConversionContext<?> conversionContext) {
        LinkedHashMap<String, Object> subMap = new LinkedHashMap<String, Object>(entries.size());
        AnnotationMetadata annotationMetadata = conversionContext.getAnnotationMetadata();
        StringConvention keyConvention = annotationMetadata.getValue(MapFormat.class, "keyFormat", StringConvention.class).orElse(StringConvention.RAW);
        String prefix = name + '.';
        for (Map.Entry<String, Object> map : entries.entrySet()) {
            Object v;
            if (!map.getKey().startsWith(prefix)) continue;
            String subMapKey = map.getKey().substring(prefix.length());
            Object value = this.resolvePlaceHoldersIfNecessary(map.getValue());
            MapFormat.MapTransformation transformation = annotationMetadata.getValue(MapFormat.class, "transformation", MapFormat.MapTransformation.class).orElse(conversionContext.isAnnotationPresent(Property.class) ? MapFormat.MapTransformation.FLAT : MapFormat.MapTransformation.NESTED);
            if (transformation == MapFormat.MapTransformation.FLAT) {
                subMapKey = keyConvention.format(subMapKey);
                subMap.put(subMapKey, value);
                continue;
            }
            int index = subMapKey.indexOf(46);
            if (index == -1) {
                subMapKey = keyConvention.format(subMapKey);
                subMap.put(subMapKey, value);
                continue;
            }
            String mapKey = subMapKey.substring(0, index);
            if (!subMap.containsKey(mapKey = keyConvention.format(mapKey))) {
                subMap.put(mapKey, new LinkedHashMap());
            }
            if ((v = subMap.get(mapKey)) instanceof Map) {
                Map nestedMap = (Map)v;
                String nestedKey = subMapKey.substring(index + 1);
                keyConvention.format(nestedKey);
                nestedMap.put(nestedKey, value);
                continue;
            }
            subMap.put(mapKey, v);
        }
        return subMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processPropertySource(PropertySource properties, PropertySource.PropertyConvention convention) {
        this.propertySources.put(properties.getName(), properties);
        Map<String, Object>[] mapArray = this.catalog;
        synchronized (this.catalog) {
            for (String property : properties) {
                Object value;
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Processing property key {}", (Object)property);
                }
                if ((value = properties.get(property)) instanceof String) {
                    String str = (String)value;
                    if (convention != PropertySource.PropertyConvention.ENVIRONMENT_VARIABLE && str.contains(this.propertyPlaceholderResolver.getPrefix())) {
                        StringBuffer newValue = new StringBuffer();
                        Matcher matcher = RANDOM_PATTERN.matcher(str);
                        boolean hasRandoms = false;
                        while (matcher.find()) {
                            String randomValue;
                            String type;
                            hasRandoms = true;
                            switch (type = matcher.group(1).trim().toLowerCase()) {
                                case "port": {
                                    randomValue = String.valueOf(SocketUtils.findAvailableTcpPort());
                                    break;
                                }
                                case "int": 
                                case "integer": {
                                    randomValue = String.valueOf(this.random.nextInt());
                                    break;
                                }
                                case "long": {
                                    randomValue = String.valueOf(this.random.nextLong());
                                    break;
                                }
                                case "float": {
                                    randomValue = String.valueOf(this.random.nextFloat());
                                    break;
                                }
                                case "shortuuid": {
                                    randomValue = UUID.randomUUID().toString().substring(25, 35);
                                    break;
                                }
                                case "uuid": {
                                    randomValue = UUID.randomUUID().toString();
                                    break;
                                }
                                case "uuid2": {
                                    randomValue = UUID.randomUUID().toString().replaceAll("-", "");
                                    break;
                                }
                                default: {
                                    throw new ConfigurationException("Invalid random expression " + matcher.group(0) + " for property: " + property);
                                }
                            }
                            matcher.appendReplacement(newValue, randomValue);
                        }
                        if (hasRandoms) {
                            matcher.appendTail(newValue);
                            value = newValue.toString();
                        }
                    }
                }
                List<String> resolvedProperties = this.resolvePropertiesForConvention(property, convention);
                for (String resolvedProperty : resolvedProperties) {
                    int i = resolvedProperty.indexOf(91);
                    if (i > -1 && resolvedProperty.endsWith("]")) {
                        LinkedHashMap<String, Object> map;
                        String index = resolvedProperty.substring(i + 1, resolvedProperty.length() - 1);
                        if (!StringUtils.isNotEmpty((CharSequence)index)) continue;
                        resolvedProperty = resolvedProperty.substring(0, i);
                        Map<String, Object> entries = this.resolveEntriesForKey(resolvedProperty, true);
                        Object v = entries.get(resolvedProperty);
                        if (StringUtils.isDigits((String)index)) {
                            ArrayList<Object> list;
                            Integer number = Integer.valueOf(index);
                            if (v instanceof List) {
                                list = (ArrayList<Object>)v;
                            } else {
                                list = new ArrayList<Object>(number);
                                entries.put(resolvedProperty, list);
                            }
                            list.add(number, value);
                            continue;
                        }
                        if (v instanceof Map) {
                            map = (LinkedHashMap<String, Object>)v;
                        } else {
                            map = new LinkedHashMap<String, Object>(10);
                            entries.put(resolvedProperty, map);
                        }
                        map.put(index, value);
                        continue;
                    }
                    Map<String, Object> entries = this.resolveEntriesForKey(resolvedProperty, true);
                    if (entries == null) continue;
                    entries.put(resolvedProperty, value);
                }
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    protected Map<String, Object> resolveEntriesForKey(String name, boolean allowCreate) {
        int index;
        Map<String, Object> entries = null;
        if (name.length() == 0) {
            return null;
        }
        char firstChar = name.charAt(0);
        if (Character.isLetter(firstChar) && (index = firstChar - 65) < this.catalog.length && index > 0) {
            entries = this.catalog[index];
            if (allowCreate && entries == null) {
                this.catalog[index] = entries = new LinkedHashMap<String, Object>(5);
            }
        }
        return entries;
    }

    protected void resetCaches() {
        this.containsCache.clear();
        this.resolvedValueCache.clear();
    }

    private String normalizeName(String name) {
        return name.replace('-', '.');
    }

    private Object resolvePlaceHoldersIfNecessary(Object value) {
        if (value instanceof CharSequence) {
            return this.propertyPlaceholderResolver.resolveRequiredPlaceholders(value.toString());
        }
        return value;
    }

    private List<String> resolvePropertiesForConvention(String property, PropertySource.PropertyConvention convention) {
        switch (convention) {
            case ENVIRONMENT_VARIABLE: {
                return Collections.singletonList(property.toLowerCase(Locale.ENGLISH).replace('_', '.'));
            }
        }
        return Collections.singletonList(NameUtils.hyphenate((String)property, (boolean)true));
    }

    private String trimIndex(String name) {
        int i = name.indexOf(91);
        if (i > -1 && name.endsWith("]")) {
            name = name.substring(0, i);
        }
        return name;
    }
}

