/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context.env;

import io.micronaut.context.env.DefaultPlaceholder;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.util.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public interface PropertyPlaceholderResolver {
    public Optional<String> resolvePlaceholders(String var1);

    default public String getPrefix() {
        return "${";
    }

    default public String resolveRequiredPlaceholders(String str) throws ConfigurationException {
        return this.resolvePlaceholders(str).orElseThrow(() -> new ConfigurationException("Unable to resolve placeholders for property: " + str));
    }

    default public List<Placeholder> resolvePropertyNames(String str) {
        try {
            int i;
            String prefix = this.getPrefix();
            if (StringUtils.isNotEmpty((CharSequence)str) && (i = str.indexOf(prefix)) != -1) {
                ArrayList<Placeholder> placeholders = new ArrayList<Placeholder>(3);
                String restOfString = str.substring(i + 2);
                while (i != -1) {
                    int e = restOfString.indexOf(125);
                    if (e > -1) {
                        String expr = restOfString.substring(0, e).trim();
                        int j = expr.indexOf(58);
                        if (j == -1) {
                            placeholders.add(new DefaultPlaceholder(expr, null));
                        } else {
                            String defaultValue = expr.substring(j + 1);
                            expr = expr.substring(0, j);
                            placeholders.add(new DefaultPlaceholder(expr, defaultValue));
                        }
                        if ((i = restOfString.indexOf(prefix)) == -1) continue;
                        restOfString = restOfString.substring(i + 2);
                        continue;
                    }
                    return Collections.emptyList();
                }
                return placeholders;
            }
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
        return Collections.emptyList();
    }

    public static interface Placeholder {
        public String getProperty();

        public Optional<String> getDefaultValue();
    }
}

