/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context.env;

import io.micronaut.context.env.PropertyPlaceholderResolver;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.util.StringUtils;
import io.micronaut.core.value.PropertyResolver;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DefaultPropertyPlaceholderResolver
implements PropertyPlaceholderResolver {
    public static final String PREFIX = "${";
    public static final String SUFFIX = "}";
    private static final Pattern ESCAPE_SEQUENCE = Pattern.compile("(.+)?:`([^`]+?)`");
    private static final Pattern ENVIRONMENT_VAR_SEQUENCE = Pattern.compile("^[\\p{Lu}_{0-9}]+");
    private static final char COLON = ':';
    private final PropertyResolver environment;
    private final String prefix;

    public DefaultPropertyPlaceholderResolver(PropertyResolver environment) {
        this.environment = environment;
        this.prefix = PREFIX;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public Optional<String> resolvePlaceholders(String str) {
        try {
            int i = str.indexOf(this.prefix);
            if (i > -1) {
                return Optional.of(this.resolvePlaceholders(str, i));
            }
            return Optional.of(str);
        }
        catch (ConfigurationException e) {
            return Optional.empty();
        }
    }

    @Override
    public String resolveRequiredPlaceholders(String str) throws ConfigurationException {
        int i = str.indexOf(this.prefix);
        if (i > -1) {
            return this.resolvePlaceholders(str, i);
        }
        return str;
    }

    protected boolean resolveReplacement(StringBuilder builder, String str, String expr) {
        if (this.environment.containsProperty(expr)) {
            builder.append((String)this.environment.getProperty(expr, String.class).orElseThrow(() -> new ConfigurationException("Could not resolve placeholder ${" + expr + "} in value: " + str)));
            return true;
        }
        return false;
    }

    private String resolvePlaceholders(String str, int startIndex) {
        StringBuilder builder = new StringBuilder(str.substring(0, startIndex));
        String restOfString = str.substring(startIndex + 2);
        int i = restOfString.indexOf(125);
        if (i > -1) {
            String expr = restOfString.substring(0, i).trim();
            if (restOfString.length() > i) {
                restOfString = restOfString.substring(i + 1);
            }
            this.resolveExpression(builder, str, expr);
            i = restOfString.indexOf(this.prefix);
            if (i > -1) {
                builder.append(this.resolvePlaceholders(restOfString, i));
            } else {
                builder.append(restOfString);
            }
        } else {
            throw new ConfigurationException("Incomplete placeholder definitions detected: " + str);
        }
        return builder.toString();
    }

    private void resolveExpression(StringBuilder builder, String str, String expr) {
        String v;
        String defaultValue = null;
        Matcher matcher = ESCAPE_SEQUENCE.matcher(expr);
        boolean escaped = false;
        if (matcher.find()) {
            defaultValue = matcher.group(2);
            expr = matcher.group(1);
            escaped = true;
        } else {
            int j = expr.indexOf(58);
            if (j > -1) {
                defaultValue = expr.substring(j + 1);
                expr = expr.substring(0, j);
            }
        }
        if (this.resolveReplacement(builder, str, expr)) {
            return;
        }
        if (ENVIRONMENT_VAR_SEQUENCE.matcher(expr).matches() && StringUtils.isNotEmpty((CharSequence)(v = System.getenv(expr)))) {
            builder.append(v);
            return;
        }
        if (defaultValue != null) {
            if (!escaped && (ESCAPE_SEQUENCE.matcher(defaultValue).find() || defaultValue.indexOf(58) > -1)) {
                StringBuilder resolved = new StringBuilder();
                this.resolveExpression(resolved, expr, defaultValue);
                builder.append((CharSequence)resolved);
            } else {
                builder.append(defaultValue);
            }
            return;
        }
        throw new ConfigurationException("Could not resolve placeholder ${" + expr + "} in value: " + str);
    }
}

