/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context;

import io.micronaut.context.ApplicationContextBuilder;
import io.micronaut.context.BeanContext;
import io.micronaut.context.DefaultApplicationContextBuilder;
import io.micronaut.context.LifeCycle;
import io.micronaut.context.Qualifier;
import io.micronaut.context.env.Environment;
import io.micronaut.context.env.PropertyPlaceholderResolver;
import io.micronaut.context.env.PropertySource;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.util.StringUtils;
import io.micronaut.core.value.PropertyResolver;
import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;

public interface ApplicationContext
extends BeanContext,
PropertyResolver,
PropertyPlaceholderResolver {
    public ConversionService<?> getConversionService();

    public Environment getEnvironment();

    @Override
    public ApplicationContext start();

    @Override
    public ApplicationContext stop();

    @Override
    public <T> ApplicationContext registerSingleton(Class<T> var1, T var2, Qualifier<T> var3, boolean var4);

    @Override
    default public <T> ApplicationContext registerSingleton(Class<T> type, T singleton, Qualifier<T> qualifier) {
        return this.registerSingleton((Class)type, (Object)singleton, (Qualifier)qualifier, true);
    }

    @Override
    default public <T> ApplicationContext registerSingleton(Class<T> type, T singleton) {
        return this.registerSingleton((Class)type, (Object)singleton, (Qualifier)null, true);
    }

    @Override
    default public ApplicationContext registerSingleton(Object singleton, boolean inject) {
        return (ApplicationContext)BeanContext.super.registerSingleton(singleton, inject);
    }

    default public ApplicationContext environment(Consumer<Environment> consumer) {
        consumer.accept(this.getEnvironment());
        return this;
    }

    @Override
    default public ApplicationContext registerSingleton(Object singleton) {
        Class<?> type = singleton.getClass();
        return this.registerSingleton((Class)type, singleton);
    }

    public static ApplicationContext run(String ... environments) {
        return ApplicationContext.build(environments).start();
    }

    public static ApplicationContext run() {
        return ApplicationContext.run(StringUtils.EMPTY_STRING_ARRAY);
    }

    public static ApplicationContext run(Map<String, Object> properties, String ... environments) {
        PropertySource propertySource = PropertySource.of("context", properties, 0);
        return ApplicationContext.run(propertySource, environments);
    }

    public static ApplicationContext run(PropertySource properties, String ... environments) {
        return ApplicationContext.build(environments).propertySources(properties).start();
    }

    public static <T extends AutoCloseable> T run(Class<T> type, String ... environments) {
        return ApplicationContext.run(type, Collections.emptyMap(), environments);
    }

    public static <T extends AutoCloseable> T run(Class<T> type, Map<String, Object> properties, String ... environments) {
        PropertySource propertySource = PropertySource.of("context", properties, 0);
        return ApplicationContext.run(type, propertySource, environments);
    }

    public static <T extends AutoCloseable> T run(Class<T> type, PropertySource propertySource, String ... environments) {
        LifeCycle lifeCycle;
        AutoCloseable bean = (AutoCloseable)ApplicationContext.build(environments).mainClass(type).propertySources(propertySource).start().getBean(type);
        if (bean != null && bean instanceof LifeCycle && !(lifeCycle = (LifeCycle)bean).isRunning()) {
            lifeCycle.start();
        }
        return (T)bean;
    }

    public static ApplicationContextBuilder build(String ... environments) {
        return new DefaultApplicationContextBuilder().environments(environments);
    }

    public static ApplicationContextBuilder build(Map<String, Object> properties, String ... environments) {
        return new DefaultApplicationContextBuilder().properties(properties).environments(environments);
    }

    public static ApplicationContextBuilder build() {
        return new DefaultApplicationContextBuilder();
    }

    public static ApplicationContext run(ClassLoader classLoader, String ... environments) {
        return ApplicationContext.build(classLoader, environments).start();
    }

    public static ApplicationContextBuilder build(ClassLoader classLoader, String ... environments) {
        return ApplicationContext.build(environments).classLoader(classLoader);
    }

    public static ApplicationContextBuilder build(Class mainClass, String ... environments) {
        return ApplicationContext.build(environments).mainClass(mainClass);
    }
}

