/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context;

import io.micronaut.context.AbstractExecutableMethod;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.Executable;
import io.micronaut.core.util.ArrayUtils;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
abstract class AbstractExecutable
implements Executable {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractExecutableMethod.class);
    protected final Class declaringType;
    protected final String methodName;
    protected final Class[] argTypes;
    private Argument[] arguments;
    private Method method;

    AbstractExecutable(Class declaringType, String methodName, Argument[] arguments) {
        Objects.requireNonNull(declaringType, "Declaring type cannot be null");
        Objects.requireNonNull(methodName, "Method name cannot be null");
        this.argTypes = Argument.toClassArray((Argument[])arguments);
        this.declaringType = declaringType;
        this.methodName = methodName;
        this.arguments = ArrayUtils.isNotEmpty((Object[])arguments) ? arguments : Argument.ZERO_ARGUMENTS;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractExecutable)) {
            return false;
        }
        AbstractExecutable that = (AbstractExecutable)o;
        return Objects.equals(this.declaringType, that.declaringType) && Objects.equals(this.methodName, that.methodName) && Arrays.equals(this.argTypes, that.argTypes);
    }

    public int hashCode() {
        int result = Objects.hash(this.declaringType, this.methodName);
        result = 31 * result + Arrays.hashCode(this.argTypes);
        return result;
    }

    public Argument[] getArguments() {
        this.initialize();
        return this.arguments;
    }

    public final Method getTargetMethod() {
        Method method = this.initialize();
        if (method == null) {
            if (LOG.isWarnEnabled() && LOG.isWarnEnabled()) {
                LOG.warn("Type [{}] previously declared a method [{}] which has been removed or changed. It is recommended you re-compile the class or library against the latest version to remove this warning.", (Object)this.declaringType, (Object)this.methodName);
            }
            throw ReflectionUtils.newNoSuchMethodError((Class)this.declaringType, (String)this.methodName, (Class[])this.argTypes);
        }
        return method;
    }

    private Method initialize() {
        if (this.method == null) {
            Method method = ReflectionUtils.getMethod((Class)this.declaringType, (String)this.methodName, (Class[])this.argTypes).orElse(null);
            if (method != null) {
                method.setAccessible(true);
                this.method = method;
                return method;
            }
            return null;
        }
        return this.method;
    }
}

