/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.gradle.docker;

import com.bmuschko.gradle.docker.tasks.image.Dockerfile;
import io.micronaut.gradle.PluginsHelper;
import io.micronaut.gradle.docker.DockerBuildOptions;
import io.micronaut.gradle.docker.DockerBuildStrategy;
import io.micronaut.gradle.docker.DockerfileEditor;
import io.micronaut.gradle.docker.model.Layer;
import io.micronaut.gradle.docker.model.LayerKind;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.gradle.api.JavaVersion;
import org.gradle.api.Project;
import org.gradle.api.file.RegularFile;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.JavaApplication;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;

public abstract class MicronautDockerfile
extends Dockerfile
implements DockerBuildOptions {
    public static final String DEFAULT_WORKING_DIR = "/home/app";
    public static final String DEFAULT_BASE_IMAGE = "eclipse-temurin:";
    @Input
    private final Property<String> baseImage;
    @Input
    private final ListProperty<String> args;
    @Input
    protected final ListProperty<Integer> exposedPorts;
    @Input
    protected final Property<DockerBuildStrategy> buildStrategy;
    @Input
    private final Property<String> defaultCommand;
    @Input
    private final Property<String> targetWorkingDirectory;

    @Input
    public abstract Property<JavaVersion> getJdkVersion();

    @Input
    public abstract ListProperty<Layer> getLayers();

    @Input
    @Optional
    public abstract Property<Boolean> getUseCopyLink();

    public MicronautDockerfile() {
        Project project = this.getProject();
        this.setGroup("build");
        this.setDescription("Builds a Docker File for a Micronaut application");
        ObjectFactory objects = project.getObjects();
        this.buildStrategy = objects.property(DockerBuildStrategy.class).convention((Object)DockerBuildStrategy.DEFAULT);
        this.baseImage = objects.property(String.class).convention((Object)"none");
        this.defaultCommand = objects.property(String.class).convention((Object)"none");
        this.args = objects.listProperty(String.class);
        this.exposedPorts = objects.listProperty(Integer.class).convention(Collections.singletonList(8080));
        this.targetWorkingDirectory = objects.property(String.class).convention((Object)DEFAULT_WORKING_DIR);
        JavaPluginExtension javaExtension = PluginsHelper.javaPluginExtensionOf((Project)project);
        this.getJdkVersion().convention((Object)javaExtension.getTargetCompatibility());
    }

    @Override
    public Property<String> getTargetWorkingDirectory() {
        return this.targetWorkingDirectory;
    }

    @Override
    public Property<String> getDefaultCommand() {
        return this.defaultCommand;
    }

    @Inject
    protected abstract ObjectFactory getObjects();

    @Input
    @Optional
    protected Provider<List<String>> getTweaks() {
        return this.getDockerfileTweaks().map(tweaks -> DockerfileEditor.fingerprintOf(this.getObjects(), tweaks));
    }

    @TaskAction
    public void create() throws IOException {
        super.create();
        MicronautDockerfile.applyStandardTransforms(this.getUseCopyLink(), this.getObjects(), this);
        if (this.getDockerfileTweaks().isPresent()) {
            DockerfileEditor.apply(this.getObjects(), this, (List)this.getDockerfileTweaks().get());
        }
        this.getLogger().lifecycle("Dockerfile written to: {}", new Object[]{((RegularFile)this.getDestFile().get()).getAsFile().getAbsolutePath()});
    }

    public static void applyStandardTransforms(Provider<Boolean> useCopyLink, ObjectFactory objects, Dockerfile task) {
        if (Boolean.TRUE.equals(useCopyLink.getOrElse((Object)true))) {
            DockerfileEditor.apply(objects, task, List.of(editor -> editor.replaceRegex("COPY (?!--link)(.*)", "COPY --link $1")));
        }
    }

    protected void setupInstructions(List<Dockerfile.Instruction> additionalInstructions) {
        String workDir = (String)this.getTargetWorkingDirectory().get();
        DockerBuildStrategy buildStrategy = (DockerBuildStrategy)this.buildStrategy.getOrElse((Object)DockerBuildStrategy.DEFAULT);
        JavaApplication javaApplication = (JavaApplication)this.getProject().getExtensions().getByType(JavaApplication.class);
        String from = (String)this.getBaseImage().getOrNull();
        if ("none".equalsIgnoreCase(from)) {
            from = null;
        }
        switch (buildStrategy) {
            case ORACLE_FUNCTION: {
                javaApplication.getMainClass().set((Object)"com.fnproject.fn.runtime.EntryPoint");
                this.from(new Dockerfile.From("fnproject/fn-java-fdk:jre17-latest").withStage("fnfdk"));
                this.from(new Dockerfile.From((String)(from != null ? from : DEFAULT_BASE_IMAGE + this.getDockerDefaultImageJavaTag())));
                this.copyFile(new Dockerfile.CopyFile("/function/", "./function").withStage("fnfdk"));
                MicronautDockerfile.setupResources(this, (List)this.getLayers().get(), "/function");
                String cmd = (String)this.defaultCommand.get();
                if ("none".equals(cmd)) {
                    super.defaultCommand(new String[]{"io.micronaut.oraclecloud.function.http.HttpFunction::handleRequest"});
                } else {
                    super.defaultCommand(new String[]{cmd});
                }
                super.entryPoint(new String[]{"java", "-XX:-UsePerfData", "-XX:+UseSerialGC", "-Xshare:auto", "-Djava.awt.headless=true", "-Djava.library.path=/function/runtime/lib", "-cp", "/function/libs/*:/function/runtime/*:/function/*:/function/resources", "com.fnproject.fn.runtime.EntryPoint"});
                break;
            }
            case LAMBDA: {
                javaApplication.getMainClass().set((Object)"io.micronaut.function.aws.runtime.MicronautLambdaRuntime");
            }
            default: {
                this.from(new Dockerfile.From((String)(from != null ? from : DEFAULT_BASE_IMAGE + this.getDockerDefaultImageJavaTag())));
                MicronautDockerfile.setupResources(this, (List)this.getLayers().get(), null);
                this.exposePort((Provider)this.exposedPorts);
                this.getInstructions().addAll(additionalInstructions);
                if (!((List)this.getInstructions().get()).stream().noneMatch(instruction -> instruction.getKeyword().equals("ENTRYPOINT"))) break;
                this.entryPoint(this.getArgs().map(strings -> {
                    ArrayList<Object> newList = new ArrayList<Object>(strings.size() + 3);
                    newList.add("java");
                    newList.addAll((Collection<Object>)strings);
                    newList.add("-jar");
                    newList.add(workDir + "/application.jar");
                    return newList;
                }));
            }
        }
    }

    public void setupDockerfileInstructions() {
        this.from("placeholder");
    }

    public void setupTaskPostEvaluate() {
        ArrayList<Dockerfile.Instruction> additionalInstructions = new ArrayList<Dockerfile.Instruction>(((List)this.getInstructions().get()).subList(1, ((List)this.getInstructions().get()).size()));
        this.getInstructions().set(new ArrayList());
        this.setupInstructions(additionalInstructions);
    }

    public Property<DockerBuildStrategy> getBuildStrategy() {
        return this.buildStrategy;
    }

    @Override
    public ListProperty<String> getArgs() {
        return this.args;
    }

    @Override
    public Property<String> getBaseImage() {
        return this.baseImage;
    }

    @Override
    public ListProperty<Integer> getExposedPorts() {
        return this.exposedPorts;
    }

    @Override
    public DockerBuildOptions args(String ... args) {
        this.args.addAll((Object[])args);
        return this;
    }

    @Override
    public DockerBuildOptions baseImage(String imageName) {
        if (imageName != null) {
            this.baseImage.set((Object)imageName);
        }
        return this;
    }

    @Override
    public DockerBuildOptions exportPorts(Integer ... ports) {
        this.exposedPorts.set(Arrays.asList(ports));
        return this;
    }

    private String getDockerDefaultImageJavaTag() {
        JavaVersion javaVersion = (JavaVersion)this.getJdkVersion().get();
        if (javaVersion.isCompatibleWith(JavaVersion.VERSION_21)) {
            return "21-jre";
        }
        if (javaVersion.isCompatibleWith(JavaVersion.VERSION_17)) {
            return "17-jre";
        }
        return "latest";
    }

    public static void setupResources(Dockerfile task, List<Layer> layers, String workDir) {
        String finalWorkDir = workDir != null ? workDir : MicronautDockerfile.determineWorkingDir(task);
        task.workingDir(finalWorkDir);
        for (Layer layer : layers) {
            task.copyFile(task.getProject().provider(() -> {
                if (layer.getFiles().isEmpty()) {
                    return null;
                }
                LayerKind kind = (LayerKind)((Object)((Object)layer.getLayerKind().get()));
                return new Dockerfile.CopyFile("layers/" + kind.sourceDirName(), finalWorkDir + "/" + kind.targetDirName());
            }));
        }
    }

    private static String determineWorkingDir(Dockerfile task) {
        String workDir = DEFAULT_WORKING_DIR;
        if (task instanceof DockerBuildOptions) {
            DockerBuildOptions dbo = (DockerBuildOptions)task;
            workDir = (String)dbo.getTargetWorkingDirectory().get();
        }
        return workDir;
    }
}

