/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.gradle.docker.tasks;

import java.io.File;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;

public class DockerResourceConfigDirectoryNamer {
    private final Map<String, Integer> counter = new HashMap<String, Integer>();

    public String determineNameFor(File configDir) {
        Integer count;
        String name = configDir.getName();
        File currentDir = configDir;
        for (int i = 0; i < 3; ++i) {
            if (currentDir == null) continue;
            currentDir = currentDir.getParentFile();
        }
        if (currentDir != null && "exploded".equals(currentDir.getName())) {
            Path fullPath = configDir.toPath();
            Path relativePath = currentDir.toPath().relativize(fullPath);
            name = relativePath.toString();
        }
        if ((count = this.counter.computeIfAbsent(name, k -> 0)) == 0) {
            return name;
        }
        Integer n = count;
        count = count + 1;
        this.counter.put(name, count);
        return name + "/" + count;
    }
}

