/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.gradle.docker.tasks;

import io.micronaut.gradle.docker.model.Layer;
import io.micronaut.gradle.docker.model.LayerKind;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.DuplicatesStrategy;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;

@CacheableTask
public abstract class BuildLayersTask
extends DefaultTask {
    @Nested
    public abstract ListProperty<Layer> getLayers();

    @Input
    @Optional
    public abstract Property<DuplicatesStrategy> getDuplicatesStrategy();

    @OutputDirectory
    public abstract DirectoryProperty getOutputDir();

    @Inject
    protected abstract FileOperations getFileOperations();

    @TaskAction
    public void action() {
        FileOperations fileOperations = this.getFileOperations();
        fileOperations.delete(new Object[]{this.getOutputDir()});
        for (Layer layer : (List)this.getLayers().get()) {
            Provider<Directory> layerDir = BuildLayersTask.layerDirectoryOf(layer, this.getOutputDir());
            if (layer.getLayerKind().get() == LayerKind.APP) {
                fileOperations.copy(copy -> {
                    this.configureDuplicatesStrategy((CopySpec)copy);
                    copy.from(new Object[]{layer.getFiles()}).into((Object)this.getOutputDir().dir("app")).rename(s -> "application.jar");
                });
                continue;
            }
            fileOperations.copy(copy -> {
                this.configureDuplicatesStrategy((CopySpec)copy);
                copy.from(new Object[]{layer.getFiles()}).into((Object)layerDir);
            });
        }
    }

    private void configureDuplicatesStrategy(CopySpec copy) {
        if (this.getDuplicatesStrategy().isPresent()) {
            copy.setDuplicatesStrategy((DuplicatesStrategy)this.getDuplicatesStrategy().get());
        }
    }

    private static Provider<Directory> layerDirectoryOf(Layer layer, DirectoryProperty outputDir) {
        LayerKind kind = (LayerKind)((Object)layer.getLayerKind().get());
        Provider dir = outputDir.dir(kind.sourceDirName());
        try {
            Files.createDirectories(((Directory)dir.get()).getAsFile().toPath(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return dir;
    }
}

