/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.gradle.docker.editor;

import io.micronaut.gradle.docker.editor.Editor;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.model.ObjectFactory;

public class DefaultEditor
implements Editor {
    private final ObjectFactory objects;
    private final List<String> lines;
    private final DefaultEditor parent;
    private final String before;
    private final String after;

    @Inject
    public DefaultEditor(ObjectFactory objects, Optional<DefaultEditor> parent, List<String> lines, Optional<String> before, Optional<String> after) {
        this.objects = objects;
        this.parent = parent.orElse(null);
        this.lines = lines;
        this.before = before.orElse(null);
        this.after = after.orElse(null);
    }

    @Override
    public void before(String line, Action<? super Editor> action) {
        DefaultEditor t = (DefaultEditor)this.objects.newInstance(DefaultEditor.class, new Object[]{this.objects, Optional.of(this), this.lines, Optional.of(line), Optional.empty()});
        action.execute((Object)t);
    }

    @Override
    public void after(String line, Action<? super Editor> action) {
        DefaultEditor t = (DefaultEditor)this.objects.newInstance(DefaultEditor.class, new Object[]{this.objects, Optional.of(this), this.lines, Optional.empty(), Optional.of(line)});
        action.execute((Object)t);
    }

    private Boundaries getBoundaries() {
        int size = this.lines.size();
        if (this.parent == null) {
            Integer start = this.after == null ? null : Integer.valueOf(this.lookupFor(this.after, 0, size) + 1);
            Integer end = this.before == null ? null : this.lookupFor(this.before, 0, size);
            return new Boundaries(start, end);
        }
        Boundaries parentBoundaries = this.parent.getBoundaries();
        Integer start = this.after == null ? parentBoundaries.start : this.lookupFor(this.after, parentBoundaries.getStart().orElse(0), parentBoundaries.getEnd().orElse(size)) + 1;
        Integer end = this.before == null ? parentBoundaries.end : this.lookupFor(this.before, parentBoundaries.getStart().orElse(0), parentBoundaries.getEnd().orElse(size));
        return new Boundaries(start, end);
    }

    private Integer lookupFor(String line, int min, int max) {
        for (int i = min; i < max; ++i) {
            if (!this.lines.get(i).equals(line)) continue;
            return i;
        }
        throw new IllegalStateException("Unable to find line " + line);
    }

    @Override
    public void replace(String replacement) {
        if (this.lines.isEmpty()) {
            throw new IllegalStateException("No lines to replace");
        }
        Boundaries boundaries = this.getBoundaries();
        int startIndex = boundaries.getStart().orElse(0);
        int endIndex = boundaries.getEnd().orElse(this.lines.size());
        for (int idx = startIndex; idx < endIndex; ++idx) {
            this.lines.set(idx, replacement);
        }
    }

    @Override
    public void replace(String line, String replacement) {
        Boundaries boundaries = this.getBoundaries();
        int startIndex = boundaries.getStart().orElse(0);
        int endIndex = boundaries.getEnd().orElse(this.lines.size());
        for (int idx = startIndex; idx < endIndex; ++idx) {
            if (!this.lines.get(idx).equals(line)) continue;
            this.lines.set(idx, replacement);
        }
    }

    @Override
    public void replaceRegex(String regex, String replacement) {
        Boundaries boundaries = this.getBoundaries();
        int startIndex = boundaries.getStart().orElse(0);
        int endIndex = boundaries.getEnd().orElse(this.lines.size());
        for (int idx = startIndex; idx < endIndex; ++idx) {
            String line = this.lines.get(idx);
            this.lines.set(idx, line.replaceAll(regex, replacement));
        }
    }

    @Override
    public void insert(String ... lines) {
        int startIndex = this.getBoundaries().getStart().orElse(0);
        this.lines.addAll(startIndex, Arrays.asList(lines));
    }

    public List<String> getLines() {
        return Collections.unmodifiableList(this.lines);
    }

    private static class Boundaries {
        private final Integer start;
        private final Integer end;

        private Boundaries(Integer start, Integer end) {
            this.start = start;
            this.end = end;
        }

        public Optional<Integer> getStart() {
            return Optional.ofNullable(this.start);
        }

        public Optional<Integer> getEnd() {
            return Optional.ofNullable(this.end);
        }
    }
}

