/*
 * Copyright 2003-2022 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.micronaut.gradle.docker.model;

import org.gradle.api.Action;
import org.gradle.api.Named;
import org.gradle.api.provider.ListProperty;

import java.util.List;

/**
 * Represents a Micronaut docker image, represented
 * with a name and a list of layers.
 * Tasks will be automatically created based on the declared
 * images.
 */
public interface MicronautDockerImage extends Named {
    ListProperty<Layer> getLayers();

    void addLayer(Action<? super Layer> spec);

    default List<Layer> findLayers(RuntimeKind runtimeKind) {
        return getLayers().map(layers -> layers.stream()
                .filter(layer -> layer.getRuntimeKind().get().isCompatibleWith(runtimeKind))
                .toList())
                .get();
    }
}
