/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.gradle.docker.editor;

import io.micronaut.gradle.docker.editor.Editor;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.model.ObjectFactory;

public class FingerprintingEditor
implements Editor {
    private final ObjectFactory objects;
    private final List<String> fingerprint;

    @Inject
    public FingerprintingEditor(ObjectFactory objects, List<String> fingerprint) {
        this.objects = objects;
        this.fingerprint = fingerprint;
    }

    @Override
    public void before(String line, Action<? super Editor> action) {
        this.fingerprint.add("BEFORE LINE " + line);
        this.fork(action);
    }

    @Override
    public void after(String line, Action<? super Editor> action) {
        this.fingerprint.add("AFTER LINE " + line);
        this.fork(action);
    }

    private void fork(Action<? super Editor> action) {
        FingerprintingEditor t = (FingerprintingEditor)this.objects.newInstance(FingerprintingEditor.class, new Object[]{this.objects, this.fingerprint});
        this.fingerprint.add("BEGIN");
        action.execute((Object)t);
        this.fingerprint.add("END");
    }

    @Override
    public void replace(String replacement) {
        this.fingerprint.add("REPLACE");
        this.fingerprint.add(replacement);
    }

    @Override
    public void replace(String line, String replacement) {
        this.fingerprint.add("REPLACE");
        this.fingerprint.add(line);
        this.fingerprint.add(replacement);
    }

    @Override
    public void insert(String ... lines) {
        this.fingerprint.add("INSERT");
        Collections.addAll(this.fingerprint, lines);
    }

    public List<String> getFingerprint() {
        return this.fingerprint;
    }
}

