/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.gradle.docker;

import com.bmuschko.gradle.docker.tasks.image.Dockerfile;
import io.micronaut.gradle.docker.DockerBuildOptions;
import io.micronaut.gradle.docker.DockerBuildStrategy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.gradle.api.JavaVersion;
import org.gradle.api.Project;
import org.gradle.api.file.RegularFile;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.JavaApplication;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.TaskAction;
import org.gradle.internal.jvm.Jvm;

public class MicronautDockerfile
extends Dockerfile
implements DockerBuildOptions {
    public static final String DEFAULT_WORKING_DIR = "/home/app";
    @Input
    private final Property<String> baseImage;
    @Input
    private final ListProperty<String> args;
    @Input
    protected final ListProperty<Integer> exposedPorts;
    @Input
    protected final Property<DockerBuildStrategy> buildStrategy;
    @Input
    private final Property<String> defaultCommand;
    @Input
    private final Property<String> targetWorkingDirectory;

    public MicronautDockerfile() {
        Project project = this.getProject();
        this.setGroup("build");
        this.setDescription("Builds a Docker File for a Micronaut application");
        ObjectFactory objects = project.getObjects();
        this.buildStrategy = objects.property(DockerBuildStrategy.class).convention((Object)DockerBuildStrategy.DEFAULT);
        this.baseImage = objects.property(String.class).convention((Object)"none");
        this.defaultCommand = objects.property(String.class).convention((Object)"none");
        this.args = objects.listProperty(String.class);
        this.exposedPorts = objects.listProperty(Integer.class).convention(Collections.singletonList(8080));
        this.targetWorkingDirectory = objects.property(String.class).convention((Object)DEFAULT_WORKING_DIR);
    }

    @Override
    public Property<String> getTargetWorkingDirectory() {
        return this.targetWorkingDirectory;
    }

    @Override
    public Property<String> getDefaultCommand() {
        return this.defaultCommand;
    }

    @TaskAction
    public void create() {
        super.create();
        System.out.println("Dockerfile written to: " + ((RegularFile)this.getDestFile().get()).getAsFile().getAbsolutePath());
    }

    protected void setupInstructions(List<Dockerfile.Instruction> additionalInstructions) {
        String workDir = (String)this.getTargetWorkingDirectory().get();
        DockerBuildStrategy buildStrategy = (DockerBuildStrategy)this.buildStrategy.getOrElse((Object)DockerBuildStrategy.DEFAULT);
        JavaApplication javaApplication = (JavaApplication)this.getProject().getExtensions().getByType(JavaApplication.class);
        String from = (String)this.getBaseImage().getOrNull();
        if ("none".equalsIgnoreCase(from)) {
            from = null;
        }
        switch (buildStrategy) {
            case ORACLE_FUNCTION: {
                javaApplication.getMainClass().set((Object)"com.fnproject.fn.runtime.EntryPoint");
                this.from(new Dockerfile.From(from != null ? from : "fnproject/fn-java-fdk:" + this.getProjectFnVersion()));
                this.workingDir("/function");
                this.runCommand("mkdir -p /function/app/resources");
                this.copyFile("layers/libs/*.jar", "/function/app/");
                this.copyFile("layers/classes", "/function/app/classes");
                this.copyFile("layers/resources", "/function/app/resources");
                this.copyFile("layers/application.jar", "/function/app/");
                String cmd = (String)this.defaultCommand.get();
                if ("none".equals(cmd)) {
                    super.defaultCommand(new String[]{"io.micronaut.oraclecloud.function.http.HttpFunction::handleRequest"});
                    break;
                }
                super.defaultCommand(new String[]{cmd});
                break;
            }
            case LAMBDA: {
                javaApplication.getMainClass().set((Object)"io.micronaut.function.aws.runtime.MicronautLambdaRuntime");
            }
            default: {
                this.from(new Dockerfile.From(from != null ? from : "openjdk:17-alpine"));
                MicronautDockerfile.setupResources(this);
                this.exposePort((Provider)this.exposedPorts);
                this.getInstructions().addAll(additionalInstructions);
                if (!((List)this.getInstructions().get()).stream().noneMatch(instruction -> instruction.getKeyword().equals("ENTRYPOINT"))) break;
                this.entryPoint(this.getArgs().map(strings -> {
                    ArrayList<String> newList = new ArrayList<String>(strings.size() + 3);
                    newList.add("java");
                    newList.addAll((Collection<String>)strings);
                    newList.add("-jar");
                    newList.add(workDir + "/application.jar");
                    return newList;
                }));
            }
        }
    }

    public void setupDockerfileInstructions() {
        this.from("placeholder");
    }

    public void setupTaskPostEvaluate() {
        ArrayList<Dockerfile.Instruction> additionalInstructions = new ArrayList<Dockerfile.Instruction>(((List)this.getInstructions().get()).subList(1, ((List)this.getInstructions().get()).size()));
        this.getInstructions().set(new ArrayList());
        this.setupInstructions(additionalInstructions);
    }

    public Property<DockerBuildStrategy> getBuildStrategy() {
        return this.buildStrategy;
    }

    @Override
    public ListProperty<String> getArgs() {
        return this.args;
    }

    @Override
    public Property<String> getBaseImage() {
        return this.baseImage;
    }

    @Override
    public ListProperty<Integer> getExposedPorts() {
        return this.exposedPorts;
    }

    @Override
    public DockerBuildOptions args(String ... args) {
        this.args.addAll((Object[])args);
        return this;
    }

    @Override
    public DockerBuildOptions baseImage(String imageName) {
        if (imageName != null) {
            this.baseImage.set((Object)imageName);
        }
        return this;
    }

    @Override
    public DockerBuildOptions exportPorts(Integer ... ports) {
        this.exposedPorts.set(Arrays.asList(ports));
        return this;
    }

    private String getProjectFnVersion() {
        JavaVersion javaVersion = Jvm.current().getJavaVersion();
        if (javaVersion != null && javaVersion.isJava11Compatible()) {
            return "jre11-latest";
        }
        return "latest";
    }

    static void setupResources(Dockerfile task) {
        String workDir = DEFAULT_WORKING_DIR;
        if (task instanceof DockerBuildOptions) {
            workDir = (String)((DockerBuildOptions)task).getTargetWorkingDirectory().get();
        }
        task.workingDir(workDir);
        task.copyFile("layers/libs", workDir + "/libs");
        task.copyFile("layers/classes", workDir + "/classes");
        task.copyFile("layers/resources", workDir + "/resources");
        task.copyFile("layers/application.jar", workDir + "/application.jar");
    }
}

