/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.gradle.docker.tasks;

import io.micronaut.gradle.docker.model.Layer;
import io.micronaut.gradle.docker.model.LayerKind;
import java.util.List;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.DuplicatesStrategy;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;

@CacheableTask
public abstract class BuildLayersTask
extends DefaultTask {
    @Nested
    public abstract ListProperty<Layer> getLayers();

    @Input
    @Optional
    public abstract Property<DuplicatesStrategy> getDuplicatesStrategy();

    @OutputDirectory
    public abstract DirectoryProperty getOutputDir();

    @Inject
    protected abstract FileOperations getFileOperations();

    @TaskAction
    public void action() {
        FileOperations fileOperations = this.getFileOperations();
        fileOperations.delete(new Object[]{this.getOutputDir()});
        Provider libsDir = this.getOutputDir().dir("libs");
        fileOperations.mkdir((Object)libsDir);
        Provider resourcesDir = this.getOutputDir().dir("resources");
        fileOperations.mkdir((Object)resourcesDir);
        Provider classesDir = this.getOutputDir().dir("classes");
        fileOperations.mkdir((Object)classesDir);
        for (Layer layer : (List)this.getLayers().get()) {
            Provider<Directory> layerDir = BuildLayersTask.layerDirectoryOf(layer, (Provider<Directory>)this.getOutputDir(), (Provider<Directory>)libsDir, (Provider<Directory>)resourcesDir, (Provider<Directory>)classesDir);
            if (layer.getLayerKind().get() == LayerKind.APP) {
                fileOperations.copy(copy -> {
                    this.configureDuplicatesStrategy((CopySpec)copy);
                    copy.from(new Object[]{layer.getFiles()}).into((Object)this.getOutputDir()).rename(s -> "application.jar");
                });
                continue;
            }
            fileOperations.copy(copy -> {
                this.configureDuplicatesStrategy((CopySpec)copy);
                copy.from(new Object[]{layer.getFiles()}).into((Object)layerDir);
            });
        }
    }

    private void configureDuplicatesStrategy(CopySpec copy) {
        if (this.getDuplicatesStrategy().isPresent()) {
            copy.setDuplicatesStrategy((DuplicatesStrategy)this.getDuplicatesStrategy().get());
        }
    }

    private static Provider<Directory> layerDirectoryOf(Layer layer, Provider<Directory> appDir, Provider<Directory> libsDir, Provider<Directory> resourcesDir, Provider<Directory> classesDir) {
        Provider<Directory> layerDir = libsDir;
        switch ((LayerKind)((Object)layer.getLayerKind().get())) {
            case APP: {
                layerDir = appDir;
                break;
            }
            case LIBS: {
                layerDir = libsDir;
                break;
            }
            case EXPANDED_CLASSES: {
                layerDir = classesDir;
                break;
            }
            case EXPANDED_RESOURCES: {
                layerDir = resourcesDir;
            }
        }
        return layerDir;
    }
}

