/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.gradle.docker;

import com.bmuschko.gradle.docker.tasks.image.Dockerfile;
import io.micronaut.gradle.docker.DockerBuildOptions;
import io.micronaut.gradle.docker.DockerBuildStrategy;
import io.micronaut.gradle.docker.DockerfileEditor;
import io.micronaut.gradle.docker.MicronautDockerfile;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.graalvm.buildtools.gradle.dsl.NativeImageCompileOptions;
import org.graalvm.buildtools.gradle.dsl.NativeImageOptions;
import org.graalvm.buildtools.gradle.dsl.NativeResourcesOptions;
import org.graalvm.buildtools.gradle.dsl.agent.DeprecatedAgentOptions;
import org.graalvm.buildtools.gradle.internal.BaseNativeImageOptions;
import org.graalvm.buildtools.gradle.internal.NativeImageCommandLineProvider;
import org.graalvm.buildtools.gradle.tasks.BuildNativeImageTask;
import org.gradle.api.Action;
import org.gradle.api.JavaVersion;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFile;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.JavaApplication;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.gradle.internal.jvm.Jvm;
import org.gradle.jvm.toolchain.JavaLanguageVersion;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.jvm.toolchain.JavaToolchainService;

public abstract class NativeImageDockerfile
extends Dockerfile
implements DockerBuildOptions {
    private static final List<Integer> SUPPORTED_JAVA_VERSIONS = Collections.unmodifiableList(Arrays.asList(17, 11));
    private static final String ARM_ARCH = "aarch64";
    private static final String X86_64_ARCH = "amd64";
    private static final String GRAAL_VERSION_CONVENTION = "22.3.2";

    @Input
    public abstract Property<String> getJdkVersion();

    @Input
    public abstract Property<String> getGraalVersion();

    @Input
    public abstract Property<String> getGraalArch();

    @Input
    public abstract Property<String> getGraalImage();

    @Override
    @Input
    @Optional
    public abstract Property<String> getBaseImage();

    @Override
    @Input
    public abstract ListProperty<String> getArgs();

    @Override
    @Input
    public abstract ListProperty<Integer> getExposedPorts();

    @Input
    public abstract Property<Boolean> getRequireGraalSdk();

    @Input
    public abstract Property<DockerBuildStrategy> getBuildStrategy();

    @Nested
    public abstract Property<NativeImageOptions> getNativeImageOptions();

    @Inject
    public abstract JavaToolchainService getJavaToolchainService();

    @Override
    @Input
    @Optional
    public abstract Property<String> getDefaultCommand();

    @Input
    @Optional
    public abstract Property<String> getGraalReleasesUrl();

    @Override
    @Input
    public abstract Property<String> getTargetWorkingDirectory();

    @Inject
    protected abstract ProviderFactory getProviders();

    @Inject
    protected abstract ObjectFactory getObjects();

    @Inject
    protected abstract ProjectLayout getLayout();

    @Input
    @Optional
    protected Provider<List<String>> getTweaks() {
        return this.getDockerfileTweaks().map(tweaks -> DockerfileEditor.fingerprintOf(this.getObjects(), tweaks));
    }

    public NativeImageDockerfile() {
        Project project = this.getProject();
        JavaPluginExtension javaExtension = (JavaPluginExtension)project.getExtensions().getByName("java");
        this.setGroup("build");
        this.setDescription("Builds a Docker File for Native Image");
        this.getDestFile().set(project.getLayout().getBuildDirectory().file("docker/DockerfileNative"));
        this.getBuildStrategy().convention((Object)DockerBuildStrategy.DEFAULT);
        this.getRequireGraalSdk().convention((Object)true);
        this.getJdkVersion().convention(javaExtension.getToolchain().getLanguageVersion().map(JavaLanguageVersion::asInt).orElse(project.getProviders().provider(() -> Integer.valueOf(Jvm.current().getJavaVersion().getMajorVersion()))).map(NativeImageDockerfile::toSupportedJavaVersion).map(v -> "java" + v));
        this.getGraalVersion().convention((Object)GRAAL_VERSION_CONVENTION);
        String osArch = System.getProperty("os.arch");
        this.getGraalArch().convention((Object)(ARM_ARCH.equals(osArch) ? ARM_ARCH : X86_64_ARCH));
        this.getTargetWorkingDirectory().convention((Object)"/home/app");
        this.getExposedPorts().convention(Collections.singletonList(8080));
        this.getGraalImage().convention(this.getGraalVersion().zip(this.getJdkVersion(), NativeImageDockerfile::toGraalVMBaseImageName));
        this.getNativeImageOptions().convention(project.getTasks().named("nativeCompile", BuildNativeImageTask.class).map(bniT -> {
            final NativeImageOptions delegate = (NativeImageOptions)bniT.getOptions().get();
            return new NativeImageOptions(){

                public String getName() {
                    return delegate.getName();
                }

                public Property<String> getImageName() {
                    return delegate.getImageName();
                }

                public Property<String> getMainClass() {
                    return delegate.getMainClass();
                }

                public ListProperty<String> getBuildArgs() {
                    return delegate.getBuildArgs();
                }

                public MapProperty<String, Object> getSystemProperties() {
                    return delegate.getSystemProperties();
                }

                public MapProperty<String, Object> getEnvironmentVariables() {
                    return delegate.getEnvironmentVariables();
                }

                public ConfigurableFileCollection getClasspath() {
                    return delegate.getClasspath();
                }

                public ListProperty<String> getJvmArgs() {
                    return delegate.getJvmArgs();
                }

                public ListProperty<String> getRuntimeArgs() {
                    return delegate.getRuntimeArgs();
                }

                public Property<Boolean> getDebug() {
                    return delegate.getDebug();
                }

                public Property<Boolean> getFallback() {
                    return delegate.getFallback();
                }

                public Property<Boolean> getVerbose() {
                    return delegate.getVerbose();
                }

                public Property<Boolean> getQuickBuild() {
                    return delegate.getQuickBuild();
                }

                public Property<Boolean> getRichOutput() {
                    return delegate.getRichOutput();
                }

                public MapProperty<Object, List<String>> getExcludeConfig() {
                    return delegate.getExcludeConfig();
                }

                public void agent(Action<? super DeprecatedAgentOptions> spec) {
                    delegate.agent(spec);
                }

                public ListProperty<String> getExcludeConfigArgs() {
                    return delegate.getExcludeConfigArgs();
                }

                public Property<Boolean> getSharedLibrary() {
                    return delegate.getSharedLibrary();
                }

                @Optional
                public Property<JavaLauncher> getJavaLauncher() {
                    return NativeImageDockerfile.this.getObjects().property(JavaLauncher.class);
                }

                public ConfigurableFileCollection getConfigurationFileDirectories() {
                    return delegate.getConfigurationFileDirectories();
                }

                public NativeResourcesOptions getResources() {
                    return delegate.getResources();
                }

                public void resources(Action<? super NativeResourcesOptions> spec) {
                    delegate.resources(spec);
                }

                public NativeImageOptions buildArgs(Object ... buildArgs) {
                    delegate.buildArgs(buildArgs);
                    return this;
                }

                public NativeImageOptions buildArgs(Iterable<?> buildArgs) {
                    delegate.buildArgs(buildArgs);
                    return this;
                }

                public NativeImageOptions systemProperties(Map<String, ?> properties) {
                    delegate.systemProperties(properties);
                    return this;
                }

                public NativeImageOptions systemProperty(String name, Object value) {
                    delegate.systemProperty(name, value);
                    return this;
                }

                public NativeImageOptions classpath(Object ... paths) {
                    delegate.classpath(paths);
                    return this;
                }

                public NativeImageOptions jvmArgs(Object ... arguments) {
                    delegate.jvmArgs(arguments);
                    return this;
                }

                public NativeImageOptions jvmArgs(Iterable<?> arguments) {
                    delegate.jvmArgs(arguments);
                    return this;
                }

                public NativeImageOptions runtimeArgs(Object ... arguments) {
                    delegate.runtimeArgs(arguments);
                    return this;
                }

                public NativeImageOptions runtimeArgs(Iterable<?> arguments) {
                    delegate.runtimeArgs(arguments);
                    return this;
                }

                public Property<Boolean> getUseFatJar() {
                    return delegate.getUseFatJar();
                }

                public DeprecatedAgentOptions getAgent() {
                    return delegate.getAgent();
                }

                public Property<String> getRequiredVersion() {
                    return delegate.getRequiredVersion();
                }
            };
        }));
        this.doLast((Action)new Action<Task>(){

            public void execute(Task task) {
                File f = ((RegularFile)NativeImageDockerfile.this.getDestFile().get()).getAsFile();
                System.out.println("Dockerfile written to: " + f.getAbsolutePath());
            }
        });
    }

    private static String toGraalVMBaseImageName(String graalVersion, String jdkVersion) {
        return "ghcr.io/graalvm/native-image:ol7-" + jdkVersion + '-' + graalVersion;
    }

    private static int toSupportedJavaVersion(int version) {
        for (Integer javaVersion : SUPPORTED_JAVA_VERSIONS) {
            if (version < javaVersion) continue;
            return javaVersion;
        }
        return SUPPORTED_JAVA_VERSIONS.stream().reduce((x, y) -> y).orElse(11);
    }

    @TaskAction
    public void create() {
        super.create();
        if (this.getDockerfileTweaks().isPresent()) {
            DockerfileEditor.apply(this.getObjects(), this, (List)this.getDockerfileTweaks().get());
        }
    }

    private void setupInstructions(List<Dockerfile.Instruction> additionalInstructions) {
        DockerBuildStrategy buildStrategy = (DockerBuildStrategy)this.getBuildStrategy().get();
        BaseImageForBuildStrategyResolver imageResolver = new BaseImageForBuildStrategyResolver(buildStrategy);
        Provider baseImageProvider = this.getProviders().provider(() -> new Dockerfile.From(imageResolver.get()));
        if (buildStrategy == DockerBuildStrategy.LAMBDA) {
            this.from(new Dockerfile.From(imageResolver.resolve()).withStage("graalvm"));
            this.environmentVariable("LANG", "en_US.UTF-8");
            this.runCommand("yum install -y gcc gcc-c++ libc6-dev zlib1g-dev curl bash zlib zlib-devel zlib-static zip tar gzip");
            String jdkVersion = (String)this.getJdkVersion().get();
            String graalVersion = (String)this.getGraalVersion().get();
            String graalArch = (String)this.getGraalArch().get();
            String fileName = "graalvm-ce-" + jdkVersion + "-linux-" + graalArch + "-" + graalVersion + ".tar.gz";
            String releasesUrl = (String)this.getGraalReleasesUrl().getOrElse((Object)"https://github.com/graalvm/graalvm-ce-builds/releases/download");
            this.runCommand("curl -4 -L " + releasesUrl + "/vm-" + graalVersion + "/" + fileName + " -o /tmp/" + fileName);
            this.runCommand("tar -zxf /tmp/" + fileName + " -C /tmp && mv /tmp/graalvm-ce-" + jdkVersion + "-" + graalVersion + " /usr/lib/graalvm");
            this.runCommand("rm -rf /tmp/*");
            this.runCommand("/usr/lib/graalvm/bin/gu install native-image");
            this.defaultCommand(new String[]{"/usr/lib/graalvm/bin/native-image"});
            this.environmentVariable("PATH", "/usr/lib/graalvm/bin:${PATH}");
            this.from(new Dockerfile.From("graalvm").withStage("builder"));
        } else {
            this.from(new Dockerfile.From((String)this.getGraalImage().get()).withStage("graalvm"));
        }
        MicronautDockerfile.setupResources(this);
        Property executable = this.getObjects().property(String.class);
        executable.set((Object)"application");
        String workDir = (String)this.getTargetWorkingDirectory().get();
        this.runCommand("mkdir " + workDir + "/config-dirs");
        this.getInstructions().addAll(this.getNativeImageOptions().map(options -> options.getConfigurationFileDirectories().getFiles().stream().map(this::toCopyResourceDirectoryInstruction).collect(Collectors.toList())));
        this.runCommand(this.getProviders().provider(() -> String.join((CharSequence)" ", this.buildActualCommandLine((Provider<String>)executable, buildStrategy, imageResolver))));
        switch (buildStrategy) {
            case ORACLE_FUNCTION: {
                this.from(new Dockerfile.From("fnproject/fn-java-fdk:" + this.getProjectFnVersion()).withStage("fnfdk"));
                this.from(baseImageProvider);
                this.workingDir("/function");
                this.copyFile(new Dockerfile.CopyFile(workDir + "/application", "/function/func").withStage("graalvm"));
                this.copyFile(new Dockerfile.CopyFile("/function/runtime/lib/*", ".").withStage("fnfdk"));
                this.entryPoint(this.getArgs().map(strings -> {
                    ArrayList<String> newList = new ArrayList<String>(strings.size() + 1);
                    newList.add("./func");
                    newList.addAll((Collection<String>)strings);
                    newList.add("-Djava.library.path=/function");
                    return newList;
                }));
                if (this.getDefaultCommand().isPresent()) {
                    this.defaultCommand(new String[]{(String)this.getDefaultCommand().get()});
                    break;
                }
                this.defaultCommand(new String[]{"io.micronaut.oraclecloud.function.http.HttpFunction::handleRequest"});
                break;
            }
            case LAMBDA: {
                this.from(baseImageProvider);
                this.workingDir("/function");
                this.runCommand("yum install -y zip");
                this.copyFile(new Dockerfile.CopyFile(workDir + "/application", "/function/func").withStage("builder"));
                String funcCmd = String.join((CharSequence)" ", (Iterable)this.getArgs().map(strings -> {
                    ArrayList<String> newList = new ArrayList<String>(strings.size() + 1);
                    newList.add("./func");
                    newList.addAll((Collection<String>)strings);
                    newList.add("-Djava.library.path=$(pwd)");
                    return newList;
                }).get());
                this.runCommand("echo \"#!/bin/sh\" >> bootstrap && echo \"set -euo pipefail\" >> bootstrap && echo \"" + funcCmd + "\" >> bootstrap");
                this.runCommand("chmod 777 bootstrap");
                this.runCommand("chmod 777 func");
                this.runCommand("zip -j function.zip bootstrap func");
                this.getInstructions().addAll(additionalInstructions);
                this.entryPoint(new String[]{"/function/func"});
                break;
            }
            default: {
                this.from(baseImageProvider);
                this.runCommand(this.getProviders().provider(() -> {
                    if (((Dockerfile.From)baseImageProvider.get()).getImage().contains("alpine-glibc")) {
                        return "apk --no-cache update && apk add libstdc++";
                    }
                    return "";
                }));
                this.exposePort((Provider)this.getExposedPorts());
                this.getInstructions().addAll(additionalInstructions);
                this.copyFile(new Dockerfile.CopyFile(workDir + "/application", "/app/application").withStage("graalvm"));
                this.entryPoint(this.getArgs().map(strings -> {
                    ArrayList<String> newList = new ArrayList<String>(strings.size() + 1);
                    newList.add("/app/application");
                    newList.addAll((Collection<String>)strings);
                    return newList;
                }));
            }
        }
    }

    private Dockerfile.CopyFileInstruction toCopyResourceDirectoryInstruction(File resourceDirectory) {
        return new Dockerfile.CopyFileInstruction(new Dockerfile.CopyFile("config-dirs/" + resourceDirectory.getName(), (String)this.getTargetWorkingDirectory().get() + "/config-dirs/" + resourceDirectory.getName()));
    }

    protected List<String> buildActualCommandLine(Provider<String> executable, DockerBuildStrategy buildStrategy, BaseImageForBuildStrategyResolver imageResolver) {
        NativeImageOptions options = this.newNativeImageOptions("actualDockerOptions");
        this.prepareNativeImageOptions(options);
        if (buildStrategy == DockerBuildStrategy.ORACLE_FUNCTION) {
            options.getMainClass().set((Object)"com.fnproject.fn.runtime.EntryPoint");
            options.getBuildArgs().add((Object)"--report-unsupported-elements-at-runtime");
        } else if (buildStrategy == DockerBuildStrategy.LAMBDA) {
            JavaApplication javaApplication = (JavaApplication)this.getProject().getExtensions().getByType(JavaApplication.class);
            if (!javaApplication.getMainClass().isPresent()) {
                options.getMainClass().set((Object)"io.micronaut.function.aws.runtime.MicronautLambdaRuntime");
            }
            if (!options.getMainClass().isPresent()) {
                options.getMainClass().set((Object)"io.micronaut.function.aws.runtime.MicronautLambdaRuntime");
            }
        }
        ArrayList<String> commandLine = new ArrayList<String>();
        commandLine.add("native-image");
        List<String> args = this.buildNativeImageCommandLineArgs(executable, options);
        commandLine.addAll(args);
        String baseImage = imageResolver.get();
        if (baseImage.equalsIgnoreCase("scratch") && !commandLine.contains("--static")) {
            commandLine.add("--static");
        }
        if (baseImage.contains("distroless") && !commandLine.contains("-H:+StaticExecutableWithDynamicLibC")) {
            commandLine.add("-H:+StaticExecutableWithDynamicLibC");
        }
        return commandLine;
    }

    private List<String> buildNativeImageCommandLineArgs(Provider<String> executable, NativeImageOptions options) {
        List args = new NativeImageCommandLineProvider(this.getProviders().provider(() -> options), executable, (Provider)this.getObjects().property(String.class), (Provider)this.getObjects().property(String.class), (Provider)this.getObjects().fileProperty(), this.getProviders().provider(() -> false)).asArguments();
        if (System.getProperty("os.name").toLowerCase().contains("windows")) {
            String current = this.getLayout().getProjectDirectory().dir(".").getAsFile().toPath().toAbsolutePath().toString();
            args = args.stream().map(arg -> {
                if (arg.contains(current)) {
                    return arg.replace(current, "").replace(File.separatorChar, '/').replace(";", ":");
                }
                return arg;
            }).collect(Collectors.toList());
        }
        return args;
    }

    private void prepareNativeImageOptions(NativeImageOptions options) {
        Property<NativeImageOptions> originalOptions = this.getNativeImageOptions();
        options.getBuildArgs().set(originalOptions.flatMap(NativeImageCompileOptions::getBuildArgs));
        options.getJvmArgs().set(originalOptions.flatMap(NativeImageCompileOptions::getJvmArgs));
        options.getMainClass().set(originalOptions.flatMap(NativeImageCompileOptions::getMainClass));
        options.getVerbose().set(originalOptions.flatMap(NativeImageCompileOptions::getVerbose));
        options.getFallback().set(originalOptions.flatMap(NativeImageCompileOptions::getFallback));
        options.getSystemProperties().set(originalOptions.flatMap(NativeImageCompileOptions::getSystemProperties));
        options.getRichOutput().set((Object)false);
        Provider remappedConfigDirectories = originalOptions.map(orig -> orig.getConfigurationFileDirectories().getFiles().stream().map(f -> (String)this.getTargetWorkingDirectory().get() + "/config-dirs/" + f.getName()).collect(Collectors.toList()));
        options.getConfigurationFileDirectories().setFrom(new Object[]{remappedConfigDirectories});
        options.getClasspath().from(new Object[]{this.getTargetWorkingDirectory().map(d -> d + "/libs/*.jar"), this.getTargetWorkingDirectory().map(d -> d + "/resources"), this.getTargetWorkingDirectory().map(d -> d + "/application.jar")});
        options.getImageName().set((Object)"application");
    }

    private NativeImageOptions newNativeImageOptions(String name) {
        return (NativeImageOptions)this.getObjects().newInstance(BaseNativeImageOptions.class, new Object[]{name, this.getObjects(), this.getProviders(), this.getJavaToolchainService(), "application"});
    }

    void setupNativeImageTaskPostEvaluate() {
        ArrayList<Dockerfile.Instruction> additionalInstructions = new ArrayList<Dockerfile.Instruction>((Collection)this.getInstructions().get());
        this.getInstructions().set(new ArrayList());
        this.setupInstructions(additionalInstructions);
    }

    @Override
    public NativeImageDockerfile args(String ... args) {
        this.getArgs().addAll((Object[])args);
        return this;
    }

    @Override
    public NativeImageDockerfile baseImage(String imageName) {
        if (imageName != null) {
            this.getBaseImage().set((Object)imageName);
        }
        return this;
    }

    @Override
    public DockerBuildOptions exportPorts(Integer ... ports) {
        this.getExposedPorts().set(Arrays.asList(ports));
        return this;
    }

    private String getProjectFnVersion() {
        JavaVersion javaVersion = Jvm.current().getJavaVersion();
        if (javaVersion != null && javaVersion.isJava11Compatible()) {
            return "jre11-latest";
        }
        return "latest";
    }

    private class BaseImageForBuildStrategyResolver {
        private final DockerBuildStrategy strategy;
        private String resolved;

        private BaseImageForBuildStrategyResolver(DockerBuildStrategy strategy) {
            this.strategy = strategy;
        }

        public String get() {
            if (this.resolved == null) {
                this.resolved = this.resolve();
            }
            return this.resolved;
        }

        private String resolve() {
            String baseImage = (String)NativeImageDockerfile.this.getBaseImage().getOrNull();
            if (this.strategy == DockerBuildStrategy.LAMBDA && baseImage == null) {
                baseImage = "amazonlinux:2";
            } else if (baseImage == null) {
                baseImage = "frolvlad/alpine-glibc:alpine-3.12";
            }
            return baseImage;
        }
    }
}

