/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.transaction.interceptor;

import io.micronaut.aop.InterceptPhase;
import io.micronaut.aop.MethodInterceptor;
import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.context.BeanLocator;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.inject.ExecutableMethod;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.transaction.TransactionOperations;
import io.micronaut.transaction.annotation.TransactionalEventListener;
import io.micronaut.transaction.support.TransactionSynchronization;
import jakarta.inject.Singleton;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Internal
public class TransactionalEventInterceptor
implements MethodInterceptor<Object, Object> {
    private static final Logger LOG = LoggerFactory.getLogger(TransactionalEventListener.class);
    private final BeanLocator beanLocator;
    private final Map<ExecutableMethod, TransactionEventInvocation> transactionInvocationMap = new ConcurrentHashMap<ExecutableMethod, TransactionEventInvocation>(10);

    public TransactionalEventInterceptor(BeanLocator beanLocator) {
        this.beanLocator = beanLocator;
    }

    public int getOrder() {
        return InterceptPhase.TRANSACTION.getPosition() - 10;
    }

    public Object intercept(final MethodInvocationContext<Object, Object> context) {
        TransactionEventInvocation transactionEventInvocation = this.transactionInvocationMap.computeIfAbsent(context.getExecutableMethod(), executableMethod -> {
            String qualifier = executableMethod.stringValue(TransactionalEventListener.class, "transactionManager").orElse(null);
            TransactionalEventListener.TransactionPhase phase = executableMethod.enumValue(TransactionalEventListener.class, TransactionalEventListener.TransactionPhase.class).orElse(TransactionalEventListener.TransactionPhase.AFTER_COMMIT);
            return new TransactionEventInvocation((TransactionOperations)this.beanLocator.getBean(TransactionOperations.class, qualifier != null ? Qualifiers.byName((String)qualifier) : null), phase);
        });
        transactionEventInvocation.transactionManager.findTransactionStatus().ifPresentOrElse(transactionStatus -> {
            final TransactionalEventListener.TransactionPhase phase = transactionEventInvocation.phase;
            transactionStatus.registerSynchronization(new TransactionSynchronization(){

                @Override
                public void beforeCommit(boolean readOnly) {
                    if (phase == TransactionalEventListener.TransactionPhase.BEFORE_COMMIT) {
                        context.proceed();
                    }
                }

                @Override
                public void afterCompletion(@NonNull TransactionSynchronization.Status status) {
                    switch (status) {
                        case ROLLED_BACK: {
                            if (phase != TransactionalEventListener.TransactionPhase.AFTER_ROLLBACK && phase != TransactionalEventListener.TransactionPhase.AFTER_COMPLETION) break;
                            context.proceed();
                            break;
                        }
                        case COMMITTED: {
                            if (phase != TransactionalEventListener.TransactionPhase.AFTER_COMMIT && phase != TransactionalEventListener.TransactionPhase.AFTER_COMPLETION) break;
                            context.proceed();
                            break;
                        }
                        default: {
                            if (phase != TransactionalEventListener.TransactionPhase.AFTER_COMPLETION) break;
                            context.proceed();
                        }
                    }
                }
            });
        }, () -> {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No active transaction, skipping event {}", context.getParameterValues()[0]);
            }
        });
        return null;
    }

    private record TransactionEventInvocation(TransactionOperations<?> transactionManager, TransactionalEventListener.TransactionPhase phase) {
    }
}

