/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.transaction;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.data.connection.ConnectionDefinition;
import io.micronaut.transaction.support.DefaultTransactionDefinition;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;

public interface TransactionDefinition {
    public static final TransactionDefinition DEFAULT = new TransactionDefinition(){

        @Override
        public String getName() {
            return "DEFAULT";
        }
    };
    public static final TransactionDefinition READ_ONLY = new TransactionDefinition(){

        @Override
        public String getName() {
            return "READ_ONLY";
        }

        @Override
        public Optional<Boolean> isReadOnly() {
            return Optional.of(Boolean.TRUE);
        }
    };
    public static final Duration TIMEOUT_DEFAULT = Duration.ofMillis(-1L);

    @NonNull
    default public Propagation getPropagationBehavior() {
        return Propagation.REQUIRED;
    }

    @NonNull
    default public Optional<Isolation> getIsolationLevel() {
        return Optional.empty();
    }

    @NonNull
    default public Optional<Duration> getTimeout() {
        return Optional.empty();
    }

    default public Optional<Boolean> isReadOnly() {
        return Optional.empty();
    }

    @Nullable
    default public String getName() {
        return null;
    }

    @NonNull
    public static TransactionDefinition of(@NonNull Propagation propagationBehaviour) {
        return new DefaultTransactionDefinition(propagationBehaviour);
    }

    @NonNull
    public static TransactionDefinition named(@NonNull String name) {
        DefaultTransactionDefinition definition = new DefaultTransactionDefinition();
        definition.setName(name);
        return definition;
    }

    @NonNull
    default public Collection<Class<? extends Throwable>> getRollbackOn() {
        return Collections.emptyList();
    }

    @NonNull
    default public Collection<Class<? extends Throwable>> getDontRollbackOn() {
        return Collections.emptyList();
    }

    default public boolean rollbackOn(Throwable e) {
        Collection<Class<? extends Throwable>> rollbackOn = this.getRollbackOn();
        if (!rollbackOn.isEmpty()) {
            for (Class<? extends Throwable> rollbackOnExClass : rollbackOn) {
                if (!rollbackOnExClass.isInstance(e)) continue;
                return true;
            }
            return false;
        }
        for (Class<? extends Throwable> dontRollbackOnExClass : this.getDontRollbackOn()) {
            if (!dontRollbackOnExClass.isInstance(e)) continue;
            return false;
        }
        return true;
    }

    default public ConnectionDefinition getConnectionDefinition() {
        if (this.getPropagationBehavior() == Propagation.REQUIRES_NEW) {
            return ConnectionDefinition.DEFAULT.withName(this.getName()).withPropagation(ConnectionDefinition.Propagation.REQUIRES_NEW);
        }
        return ConnectionDefinition.DEFAULT.withName(this.getName());
    }

    public static enum Propagation {
        REQUIRED,
        SUPPORTS,
        MANDATORY,
        REQUIRES_NEW,
        NOT_SUPPORTED,
        NEVER,
        NESTED;

    }

    public static enum Isolation {
        DEFAULT(-1),
        READ_UNCOMMITTED(1),
        READ_COMMITTED(2),
        REPEATABLE_READ(4),
        SERIALIZABLE(8);

        private final int code;

        private Isolation(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        public static Isolation valueOf(int code) {
            return switch (code) {
                case 1 -> READ_UNCOMMITTED;
                case 2 -> READ_COMMITTED;
                case 4 -> REPEATABLE_READ;
                case 8 -> SERIALIZABLE;
                default -> DEFAULT;
            };
        }
    }
}

