/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.transaction.support;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.transaction.support.DefaultSynchronousTransactionState;
import io.micronaut.transaction.support.ResourceHolder;
import io.micronaut.transaction.support.SynchronousTransactionState;
import io.micronaut.transaction.support.TransactionSynchronization;
import io.micronaut.transaction.support.TransactionSynchronizationUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TransactionSynchronizationManager {
    public static final Object DEFAULT_STATE_KEY = new Object();
    private static final Logger LOG = LoggerFactory.getLogger(TransactionSynchronizationManager.class);
    private static final ThreadLocal<MutableTransactionSynchronizationState> STATE = new ThreadLocal<MutableTransactionSynchronizationState>(){

        public String toString() {
            return "The state";
        }
    };

    @NonNull
    private static MutableTransactionSynchronizationState getOrCreateInternalState() {
        MutableTransactionSynchronizationState mutableState = STATE.get();
        if (mutableState == null) {
            mutableState = new MutableTransactionSynchronizationState();
            STATE.set(mutableState);
        }
        return mutableState;
    }

    @NonNull
    private static MutableTransactionSynchronizationState getInternalState() {
        MutableTransactionSynchronizationState mutableState = STATE.get();
        if (mutableState == null) {
            mutableState = new MutableTransactionSynchronizationState();
        }
        return mutableState;
    }

    public static Map<Object, Object> getResourceMap() {
        return Collections.unmodifiableMap(TransactionSynchronizationManager.getInternalState().getResources());
    }

    public static boolean hasResource(Object key) {
        Object actualKey = TransactionSynchronizationUtils.unwrapResourceIfNecessary(key);
        Object value = TransactionSynchronizationManager.doGetResource(TransactionSynchronizationManager.getInternalState().getResources(), actualKey);
        return value != null;
    }

    @Nullable
    public static Object getResource(Object key) {
        Object actualKey = TransactionSynchronizationUtils.unwrapResourceIfNecessary(key);
        Object value = TransactionSynchronizationManager.doGetResource(TransactionSynchronizationManager.getInternalState().getResources(), actualKey);
        if (value != null && LOG.isTraceEnabled()) {
            LOG.trace("Retrieved value [" + value + "] for key [" + actualKey + "] bound to thread [" + Thread.currentThread().getName() + "]");
        }
        return value;
    }

    @NonNull
    public static <T> T getResourceOrDefault(Object key, @NonNull T defaultValue) {
        Object resource = TransactionSynchronizationManager.getResource(key);
        return (T)(resource == null ? defaultValue : resource);
    }

    @Nullable
    private static <T> T doGetResource(@Nullable Map<Object, T> map, @NonNull Object actualKey) {
        if (map == null) {
            return null;
        }
        T value = map.get(actualKey);
        if (value instanceof ResourceHolder && ((ResourceHolder)value).isVoid()) {
            map.remove(actualKey);
            value = null;
        }
        return value;
    }

    public static void bindResource(Object key, Object value) throws IllegalStateException {
        TransactionSynchronizationManager.bindResource(TransactionSynchronizationManager.getOrCreateInternalState().getResources(), key, value);
    }

    public static void rebindResource(Object key, Object value) throws IllegalStateException {
        Object resource = TransactionSynchronizationManager.getResource(key);
        if (resource == null) {
            TransactionSynchronizationManager.bindResource(key, value);
        } else if (resource != value) {
            TransactionSynchronizationManager.unbindResource(key);
            TransactionSynchronizationManager.bindResource(key, value);
        }
    }

    private static <T> void bindResource(Map<Object, T> map, Object key, T value) {
        Object actualKey = TransactionSynchronizationUtils.unwrapResourceIfNecessary(key);
        Objects.requireNonNull(value, "Value must not be null");
        T oldValue = map.put(actualKey, value);
        if (oldValue instanceof ResourceHolder && ((ResourceHolder)oldValue).isVoid()) {
            oldValue = null;
        }
        if (oldValue != null) {
            throw new IllegalStateException("Already value [" + oldValue + "] for key [" + actualKey + "] bound to thread [" + Thread.currentThread().getName() + "]");
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Bound value [" + value + "] for key [" + actualKey + "] to thread [" + Thread.currentThread().getName() + "]");
        }
    }

    public static Object unbindResource(Object key) throws IllegalStateException {
        Object actualKey = TransactionSynchronizationUtils.unwrapResourceIfNecessary(key);
        Object value = TransactionSynchronizationManager.doUnbindResource(TransactionSynchronizationManager.getInternalState().getResources(), actualKey);
        if (value == null) {
            throw new IllegalStateException("No value for key [" + actualKey + "] bound to thread [" + Thread.currentThread().getName() + "]");
        }
        return value;
    }

    @Nullable
    public static Object unbindResourceIfPossible(Object key) {
        Object actualKey = TransactionSynchronizationUtils.unwrapResourceIfNecessary(key);
        return TransactionSynchronizationManager.doUnbindResource(TransactionSynchronizationManager.getInternalState().getResources(), actualKey);
    }

    @Nullable
    private static <T> T doUnbindResource(@Nullable Map<Object, T> map, @NonNull Object actualKey) {
        Object value;
        Object v0 = value = map == null ? null : map.remove(actualKey);
        if (value instanceof ResourceHolder && ((ResourceHolder)value).isVoid()) {
            value = null;
        }
        if (value != null && LOG.isTraceEnabled()) {
            LOG.trace("Removed value [" + value + "] for key [" + actualKey + "] from thread [" + Thread.currentThread().getName() + "]");
        }
        return value;
    }

    public static void bindSynchronousTransactionState(@NonNull Object key, @NonNull SynchronousTransactionState state) {
        TransactionSynchronizationManager.bindResource(TransactionSynchronizationManager.getOrCreateInternalState().getStates(), key, state);
    }

    public static SynchronousTransactionState unbindSynchronousTransactionState(Object key) throws IllegalStateException {
        Object actualKey = TransactionSynchronizationUtils.unwrapResourceIfNecessary(key);
        SynchronousTransactionState value = TransactionSynchronizationManager.doUnbindResource(TransactionSynchronizationManager.getInternalState().getStates(), actualKey);
        if (value == null) {
            throw new IllegalStateException("No value for key [" + actualKey + "] bound to thread [" + Thread.currentThread().getName() + "]");
        }
        return value;
    }

    @Nullable
    public static SynchronousTransactionState getSynchronousTransactionState(@NonNull Object key) {
        Object actualKey = TransactionSynchronizationUtils.unwrapResourceIfNecessary(key);
        SynchronousTransactionState value = TransactionSynchronizationManager.doGetResource(TransactionSynchronizationManager.getInternalState().getStates(), actualKey);
        if (value != null && LOG.isTraceEnabled()) {
            LOG.trace("Retrieved value [" + value + "] for key [" + actualKey + "] bound to thread [" + Thread.currentThread().getName() + "]");
        }
        return value;
    }

    @NonNull
    public static SynchronousTransactionState getRequiredSynchronousTransactionState(@NonNull Object key) {
        Object actualKey = TransactionSynchronizationUtils.unwrapResourceIfNecessary(key);
        SynchronousTransactionState value = TransactionSynchronizationManager.doGetResource(TransactionSynchronizationManager.getInternalState().getStates(), actualKey);
        if (value == null) {
            throw new IllegalStateException("No value for key [" + actualKey + "] bound to thread [" + Thread.currentThread().getName() + "]");
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Retrieved value [" + value + "] for key [" + actualKey + "] bound to thread [" + Thread.currentThread().getName() + "]");
        }
        return value;
    }

    @NonNull
    public static SynchronousTransactionState getSynchronousTransactionStateOrCreate(@NonNull Object key, Supplier<SynchronousTransactionState> creator) {
        Object actualKey = TransactionSynchronizationUtils.unwrapResourceIfNecessary(key);
        SynchronousTransactionState value = TransactionSynchronizationManager.doGetResource(TransactionSynchronizationManager.getOrCreateInternalState().getStates(), actualKey);
        if (value != null && LOG.isTraceEnabled()) {
            LOG.trace("Retrieved value [" + value + "] for key [" + actualKey + "] bound to thread [" + Thread.currentThread().getName() + "]");
        }
        if (value == null) {
            value = creator.get();
            TransactionSynchronizationManager.bindSynchronousTransactionState(actualKey, value);
        }
        return value;
    }

    @Nullable
    private static SynchronousTransactionState findDefaultState() {
        Map<Object, SynchronousTransactionState> states = TransactionSynchronizationManager.getInternalState().getStates();
        if (states.isEmpty()) {
            return null;
        }
        if (states.size() == 1) {
            return states.values().iterator().next();
        }
        SynchronousTransactionState synchronousTransactionState = states.get(DEFAULT_STATE_KEY);
        if (synchronousTransactionState != null) {
            return synchronousTransactionState;
        }
        throw new IllegalStateException("Multiple synchronous transaction states found!");
    }

    @NonNull
    private static SynchronousTransactionState getOrEmptyDefaultState() {
        SynchronousTransactionState synchronousTransactionState = TransactionSynchronizationManager.findDefaultState();
        return synchronousTransactionState == null ? new DefaultSynchronousTransactionState() : synchronousTransactionState;
    }

    @NonNull
    private static SynchronousTransactionState getRequiredDefaultState() {
        SynchronousTransactionState synchronousTransactionState = TransactionSynchronizationManager.findDefaultState();
        if (synchronousTransactionState == null) {
            throw new IllegalStateException("Cannot find default synchronous transaction state!");
        }
        return synchronousTransactionState;
    }

    @Deprecated
    public static boolean isSynchronizationActive() {
        return TransactionSynchronizationManager.getOrEmptyDefaultState().isSynchronizationActive();
    }

    @Deprecated
    public static void registerSynchronization(TransactionSynchronization synchronization) throws IllegalStateException {
        TransactionSynchronizationManager.getRequiredDefaultState().registerSynchronization(synchronization);
    }

    @Internal
    @Nullable
    public static TransactionSynchronizationState getState() {
        return STATE.get();
    }

    @Internal
    @NonNull
    public static TransactionSynchronizationState getOrCreateState() {
        return TransactionSynchronizationManager.getOrCreateInternalState();
    }

    @Internal
    public static void setState(@Nullable TransactionSynchronizationState state) {
        if (state == null) {
            STATE.remove();
            return;
        }
        if (!(state instanceof MutableTransactionSynchronizationState)) {
            throw new IllegalStateException("Unknown state: " + state);
        }
        MutableTransactionSynchronizationState mutableState = (MutableTransactionSynchronizationState)state;
        STATE.set(mutableState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Internal
    public static <T> T withState(@Nullable TransactionSynchronizationState state, Supplier<T> supplier) {
        TransactionSynchronizationState previousState = TransactionSynchronizationManager.getState();
        try {
            TransactionSynchronizationManager.setState(state);
            T t = supplier.get();
            return t;
        }
        finally {
            TransactionSynchronizationManager.setState(previousState);
        }
    }

    @Internal
    public static <T> CompletionStage<T> decorateCompletionStage(@Nullable TransactionSynchronizationState state, Supplier<CompletionStage<T>> supplier) {
        if (state == null) {
            return supplier.get();
        }
        try (TransactionSynchronizationStateOp ignore = TransactionSynchronizationManager.withState(state);){
            CompletableFuture completableFuture = new CompletableFuture();
            supplier.get().whenComplete((value, throwable) -> {
                try (TransactionSynchronizationStateOp ignore2 = TransactionSynchronizationManager.withState(state);){
                    if (throwable != null) {
                        completableFuture.completeExceptionally((Throwable)throwable);
                    } else {
                        completableFuture.complete(value);
                    }
                }
            });
            CompletableFuture completableFuture2 = completableFuture;
            return completableFuture2;
        }
    }

    @Internal
    public static TransactionSynchronizationStateOp withState(final @Nullable TransactionSynchronizationState state) {
        final TransactionSynchronizationState previousState = TransactionSynchronizationManager.getState();
        TransactionSynchronizationManager.setState(state);
        return new TransactionSynchronizationStateOp(){

            @Override
            public TransactionSynchronizationState getState() {
                return state;
            }

            @Override
            public TransactionSynchronizationState getOrCreateState() {
                return TransactionSynchronizationManager.getOrCreateState();
            }

            @Override
            public void close() {
                TransactionSynchronizationManager.setState(previousState);
            }
        };
    }

    @Internal
    public static TransactionSynchronizationStateOp withGuardedState() {
        TransactionSynchronizationState previousState = TransactionSynchronizationManager.getState();
        TransactionSynchronizationState newState = previousState == null ? null : previousState.copy();
        return TransactionSynchronizationManager.withState(newState);
    }

    @Internal
    public static <T> Supplier<T> decorateToPropagateState(Supplier<T> supplier) {
        TransactionSynchronizationState state = STATE.get();
        if (state == null) {
            return supplier;
        }
        TransactionSynchronizationState stateCopy = state.copy();
        return () -> {
            try (TransactionSynchronizationStateOp ignore = TransactionSynchronizationManager.withState(stateCopy);){
                Object t = supplier.get();
                return t;
            }
        };
    }

    private static final class MutableTransactionSynchronizationState
    implements TransactionSynchronizationState {
        private final Map<Object, Object> resources;
        private final Map<Object, SynchronousTransactionState> states;

        private MutableTransactionSynchronizationState() {
            this(new HashMap<Object, Object>(2, 1.0f), new HashMap<Object, SynchronousTransactionState>(2, 1.0f));
        }

        private MutableTransactionSynchronizationState(Map<Object, Object> resources, Map<Object, SynchronousTransactionState> states) {
            this.resources = resources;
            this.states = states;
        }

        @NonNull
        public synchronized Map<Object, Object> getResources() {
            return this.resources;
        }

        @NonNull
        public synchronized Map<Object, SynchronousTransactionState> getStates() {
            return this.states;
        }

        @Override
        public MutableTransactionSynchronizationState copy() {
            return new MutableTransactionSynchronizationState(new HashMap<Object, Object>(this.resources), new HashMap<Object, SynchronousTransactionState>(this.states));
        }
    }

    @Internal
    public static interface TransactionSynchronizationState {
        public TransactionSynchronizationState copy();
    }

    public static interface TransactionSynchronizationStateOp
    extends AutoCloseable {
        @Nullable
        public TransactionSynchronizationState getState();

        @NonNull
        public TransactionSynchronizationState getOrCreateState();

        @Override
        public void close();
    }
}

