/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.transaction.hibernate;

import io.micronaut.context.BeanProvider;
import io.micronaut.core.annotation.TypeHint;
import io.micronaut.data.connection.ConnectionOperations;
import io.micronaut.data.connection.ConnectionStatus;
import io.micronaut.transaction.hibernate.ConnectionOperationsProviderService;
import java.util.Optional;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.context.spi.CurrentSessionContext;
import org.hibernate.engine.spi.SessionFactoryImplementor;

@TypeHint(value={MicronautSessionContext.class})
public class MicronautSessionContext
implements CurrentSessionContext {
    private final BeanProvider<ConnectionOperations<Session>> connectionOperationProvider;

    public MicronautSessionContext(SessionFactoryImplementor sessionFactory) {
        this.connectionOperationProvider = ((ConnectionOperationsProviderService)sessionFactory.getServiceRegistry().getService(ConnectionOperationsProviderService.class)).provider();
    }

    public Session currentSession() throws HibernateException {
        Optional connectionStatus = ((ConnectionOperations)this.connectionOperationProvider.get()).findConnectionStatus();
        if (connectionStatus.isEmpty()) {
            throw new HibernateException("Could not obtain transaction-synchronized Session for current thread");
        }
        return (Session)((ConnectionStatus)connectionStatus.get()).getConnection();
    }
}

