/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.spring.jdbc;

import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.data.exceptions.DataAccessException;
import io.micronaut.transaction.TransactionCallback;
import io.micronaut.transaction.TransactionDefinition;
import io.micronaut.transaction.TransactionOperations;
import io.micronaut.transaction.TransactionStatus;
import io.micronaut.transaction.exceptions.NoTransactionException;
import io.micronaut.transaction.exceptions.TransactionException;
import java.lang.reflect.UndeclaredThrowableException;
import java.sql.Connection;
import java.sql.SQLException;
import java.time.Duration;
import javax.sql.DataSource;
import org.springframework.jdbc.datasource.ConnectionHolder;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.transaction.support.TransactionTemplate;

@EachBean(value=DataSourceTransactionManager.class)
@Internal
@Requires(classes={DataSourceTransactionManager.class})
public class SpringJdbcTransactionOperations
implements TransactionOperations<Connection> {
    private final TransactionTemplate writeTransactionTemplate;
    private final TransactionTemplate readTransactionTemplate;
    private final DataSource dataSource;
    private final DataSourceTransactionManager transactionManager;

    protected SpringJdbcTransactionOperations(DataSourceTransactionManager transactionManager) {
        this.dataSource = transactionManager.getDataSource();
        this.transactionManager = transactionManager;
        this.writeTransactionTemplate = new TransactionTemplate((PlatformTransactionManager)transactionManager);
        DefaultTransactionDefinition transactionDefinition = new DefaultTransactionDefinition();
        transactionDefinition.setReadOnly(true);
        this.readTransactionTemplate = new TransactionTemplate((PlatformTransactionManager)transactionManager, (org.springframework.transaction.TransactionDefinition)transactionDefinition);
    }

    public <R> R executeRead(@NonNull TransactionCallback<Connection, R> callback) {
        ArgumentUtils.requireNonNull((String)"callback", callback);
        return (R)this.readTransactionTemplate.execute(status -> {
            try {
                return callback.call((TransactionStatus)new JdbcTransactionStatus(status));
            }
            catch (Error | RuntimeException ex) {
                throw ex;
            }
            catch (Exception e) {
                throw new UndeclaredThrowableException(e, "TransactionCallback threw undeclared checked exception");
            }
        });
    }

    public <R> R executeWrite(@NonNull TransactionCallback<Connection, R> callback) {
        ArgumentUtils.requireNonNull((String)"callback", callback);
        return (R)this.writeTransactionTemplate.execute(status -> {
            try {
                return callback.call((TransactionStatus)new JdbcTransactionStatus(status));
            }
            catch (Error | RuntimeException ex) {
                throw ex;
            }
            catch (Exception e) {
                throw new UndeclaredThrowableException(e, "TransactionCallback threw undeclared checked exception");
            }
        });
    }

    public <R> R execute(@NonNull TransactionDefinition definition, @NonNull TransactionCallback<Connection, R> callback) {
        ArgumentUtils.requireNonNull((String)"callback", callback);
        ArgumentUtils.requireNonNull((String)"definition", (Object)definition);
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setReadOnly(definition.isReadOnly());
        def.setIsolationLevel(definition.getIsolationLevel().getCode());
        def.setPropagationBehavior(definition.getPropagationBehavior().ordinal());
        def.setName(definition.getName());
        Duration timeout = definition.getTimeout();
        if (!timeout.isNegative()) {
            def.setTimeout((int)timeout.getSeconds());
        }
        TransactionTemplate template = new TransactionTemplate((PlatformTransactionManager)this.transactionManager, (org.springframework.transaction.TransactionDefinition)def);
        return (R)template.execute(status -> {
            try {
                return callback.call((TransactionStatus)new JdbcTransactionStatus(status));
            }
            catch (Error | RuntimeException ex) {
                throw ex;
            }
            catch (Exception e) {
                throw new UndeclaredThrowableException(e, "TransactionCallback threw undeclared checked exception");
            }
        });
    }

    @NonNull
    public Connection getConnection() {
        try {
            Connection connection = DataSourceUtils.doGetConnection((DataSource)this.dataSource);
            if (DataSourceUtils.isConnectionTransactional((Connection)connection, (DataSource)this.dataSource)) {
                return connection;
            }
            connection.close();
            throw new NoTransactionException("No transaction declared. Define @Transactional on the surrounding method prior to calling getConnection()");
        }
        catch (SQLException e) {
            throw new DataAccessException("Error retrieving JDBC connection: " + e.getMessage(), (Throwable)e);
        }
    }

    public boolean hasConnection() {
        ConnectionHolder conHolder = (ConnectionHolder)TransactionSynchronizationManager.getResource((Object)this.dataSource);
        return conHolder != null && conHolder.getConnectionHandle() != null;
    }

    private final class JdbcTransactionStatus
    implements TransactionStatus<Connection> {
        private final org.springframework.transaction.TransactionStatus springStatus;

        JdbcTransactionStatus(org.springframework.transaction.TransactionStatus springStatus) {
            this.springStatus = springStatus;
        }

        public boolean isNewTransaction() {
            return this.springStatus.isNewTransaction();
        }

        public void setRollbackOnly() {
            this.springStatus.setRollbackOnly();
        }

        public boolean isRollbackOnly() {
            return this.springStatus.isRollbackOnly();
        }

        public boolean isCompleted() {
            return this.springStatus.isCompleted();
        }

        public boolean hasSavepoint() {
            return this.springStatus.hasSavepoint();
        }

        public void flush() {
            this.springStatus.flush();
        }

        @NonNull
        public Object getTransaction() {
            return this.springStatus;
        }

        @NonNull
        public Connection getConnection() {
            return SpringJdbcTransactionOperations.this.getConnection();
        }

        public Object createSavepoint() throws TransactionException {
            return this.springStatus.createSavepoint();
        }

        public void rollbackToSavepoint(Object savepoint) throws TransactionException {
            this.springStatus.rollbackToSavepoint(savepoint);
        }

        public void releaseSavepoint(Object savepoint) throws TransactionException {
            this.springStatus.releaseSavepoint(savepoint);
        }
    }
}

