/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.spring.jpa.intercept;

import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.data.intercept.RepositoryMethodKey;
import io.micronaut.data.jpa.operations.JpaRepositoryOperations;
import io.micronaut.data.operations.RepositoryOperations;
import io.micronaut.data.runtime.intercept.AbstractQueryInterceptor;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.From;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.util.List;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.query.QueryUtils;

@Internal
public final class FindPageSpecificationInterceptor
extends AbstractQueryInterceptor<Object, Object> {
    private final JpaRepositoryOperations jpaOperations;

    FindPageSpecificationInterceptor(@NonNull RepositoryOperations operations) {
        super(operations);
        JpaRepositoryOperations jpaRepositoryOperations;
        if (!(operations instanceof JpaRepositoryOperations)) {
            throw new IllegalStateException("Repository operations must be na instance of JpaRepositoryOperations");
        }
        this.jpaOperations = jpaRepositoryOperations = (JpaRepositoryOperations)operations;
    }

    public Object intercept(RepositoryMethodKey methodKey, MethodInvocationContext<Object, Object> context) {
        Object[] parameterValues = context.getParameterValues();
        if (parameterValues.length != 2) {
            throw new IllegalStateException("Expected exactly 2 arguments to method");
        }
        Object parameterValue = parameterValues[0];
        Object pageableObject = parameterValues[1];
        if (parameterValue instanceof Specification) {
            Specification specification = (Specification)parameterValue;
            EntityManager entityManager = this.jpaOperations.getCurrentEntityManager();
            CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
            CriteriaQuery query = criteriaBuilder.createQuery(this.getRequiredRootEntity(context));
            Root root = query.from(this.getRequiredRootEntity(context));
            Predicate predicate = specification.toPredicate(root, query, criteriaBuilder);
            if (predicate != null) {
                query.where((Expression)predicate);
            }
            query.select((Selection)root);
            if (pageableObject instanceof Pageable) {
                Pageable pageable = (Pageable)pageableObject;
                Sort sort = pageable.getSort();
                if (sort.isSorted()) {
                    List orders = QueryUtils.toOrders((Sort)sort, (From)root, (CriteriaBuilder)criteriaBuilder);
                    query.orderBy(orders);
                }
                TypedQuery typedQuery = entityManager.createQuery(query);
                if (pageable.isUnpaged()) {
                    return new PageImpl(typedQuery.getResultList());
                }
                typedQuery.setFirstResult((int)pageable.getOffset());
                typedQuery.setMaxResults(pageable.getPageSize());
                List results = typedQuery.getResultList();
                CriteriaQuery countQuery = criteriaBuilder.createQuery(Long.class);
                Root countRoot = countQuery.from(this.getRequiredRootEntity(context));
                Predicate countPredicate = specification.toPredicate(countRoot, countQuery, criteriaBuilder);
                countQuery.where((Expression)countPredicate);
                if (countQuery.isDistinct()) {
                    countQuery.select((Selection)criteriaBuilder.countDistinct((Expression)countRoot));
                } else {
                    countQuery.select((Selection)criteriaBuilder.count((Expression)countRoot));
                }
                return new PageImpl(results, pageable, ((Long)entityManager.createQuery(countQuery).getSingleResult()).longValue());
            }
            return new PageImpl(entityManager.createQuery(query).getResultList());
        }
        throw new IllegalArgumentException("Argument must be an instance of: " + String.valueOf(Specification.class));
    }
}

