/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.spring.jpa.hibernate;

import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.context.annotation.Replaces;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.data.connection.jdbc.advice.DelegatingDataSource;
import javax.sql.DataSource;
import org.hibernate.SessionFactory;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.orm.hibernate5.HibernateTransactionManager;

@Internal
@Factory
@Requires(classes={HibernateTransactionManager.class})
public final class HibernateTransactionManagerFactory {
    @Bean
    @Replaces(value=DataSourceTransactionManager.class)
    @Requires(classes={HibernateTransactionManager.class})
    @EachBean(value=SessionFactory.class)
    HibernateTransactionManager hibernateTransactionManager(SessionFactory sessionFactory, @Parameter DataSource dataSource) {
        HibernateTransactionManager hibernateTransactionManager = new HibernateTransactionManager(sessionFactory);
        hibernateTransactionManager.setDataSource(DelegatingDataSource.unwrapDataSource((DataSource)dataSource));
        return hibernateTransactionManager;
    }
}

