/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.spring.jpa.hibernate;

import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.data.connection.ConnectionStatus;
import io.micronaut.data.spring.jpa.hibernate.SpringHibernateTransactionManagerCondition;
import io.micronaut.data.spring.tx.AbstractSpringTransactionOperations;
import io.micronaut.transaction.TransactionCallback;
import io.micronaut.transaction.TransactionDefinition;
import io.micronaut.transaction.TransactionOperations;
import io.micronaut.transaction.TransactionStatus;
import io.micronaut.transaction.exceptions.TransactionException;
import io.micronaut.transaction.support.TransactionSynchronization;
import java.sql.Connection;
import java.util.Optional;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.engine.spi.SessionImplementor;
import org.springframework.orm.hibernate5.HibernateTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;

@Requires(classes={HibernateTransactionManager.class}, condition=SpringHibernateTransactionManagerCondition.class)
@EachBean(value=HibernateTransactionManager.class)
@Internal
public final class SpringHibernateTransactionOperations
implements TransactionOperations<Session> {
    private final SpringJdbcConnectionTransactionOperations transactionOperations;
    private final SessionFactory sessionFactory;

    SpringHibernateTransactionOperations(HibernateTransactionManager hibernateTransactionManager) {
        this.sessionFactory = hibernateTransactionManager.getSessionFactory();
        this.transactionOperations = new SpringJdbcConnectionTransactionOperations(hibernateTransactionManager);
    }

    public Optional<? extends TransactionStatus<?>> findTransactionStatus() {
        return this.transactionOperations.findTransactionStatus();
    }

    public Session getConnection() {
        return this.sessionFactory.getCurrentSession();
    }

    public boolean hasConnection() {
        return this.transactionOperations.hasConnection();
    }

    public <R> R execute(final TransactionDefinition definition, TransactionCallback<Session, R> callback) {
        return (R)this.transactionOperations.execute(definition, status -> callback.call((TransactionStatus)new TransactionStatus<Session>(){

            public boolean hasSavepoint() {
                return status.hasSavepoint();
            }

            public Object getTransaction() {
                return status.getTransaction();
            }

            public Session getConnection() {
                return SpringHibernateTransactionOperations.this.sessionFactory.getCurrentSession();
            }

            public ConnectionStatus<Session> getConnectionStatus() {
                throw new IllegalStateException("Connection status is not supported for Spring Hibernate TX manager!");
            }

            public Object createSavepoint() throws TransactionException {
                return status.createSavepoint();
            }

            public void rollbackToSavepoint(Object savepoint) throws TransactionException {
                status.releaseSavepoint(savepoint);
            }

            public void releaseSavepoint(Object savepoint) throws TransactionException {
                status.releaseSavepoint(savepoint);
            }

            public boolean isNewTransaction() {
                return status.isNewTransaction();
            }

            public void setRollbackOnly() {
                status.setRollbackOnly();
            }

            public boolean isRollbackOnly() {
                return status.isRollbackOnly();
            }

            public boolean isCompleted() {
                return status.isCompleted();
            }

            public TransactionDefinition getTransactionDefinition() {
                return definition;
            }

            public void registerSynchronization(TransactionSynchronization synchronization) {
                status.registerSynchronization(synchronization);
            }
        }));
    }

    private static final class SpringJdbcConnectionTransactionOperations
    extends AbstractSpringTransactionOperations {
        private final SessionFactory sessionFactory;

        SpringJdbcConnectionTransactionOperations(HibernateTransactionManager hibernateTransactionManager) {
            super((PlatformTransactionManager)hibernateTransactionManager);
            this.sessionFactory = hibernateTransactionManager.getSessionFactory();
        }

        public Connection getConnection() {
            SessionImplementor session = (SessionImplementor)this.sessionFactory.getCurrentSession();
            return session.getJdbcCoordinator().getLogicalConnection().getPhysicalConnection();
        }

        public boolean hasConnection() {
            SessionImplementor session = (SessionImplementor)this.sessionFactory.getCurrentSession();
            return session.isConnected();
        }
    }
}

