/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.spring.jpa.intercept;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.type.ReturnType;
import io.micronaut.data.intercept.RepositoryMethodKey;
import io.micronaut.data.jpa.operations.JpaRepositoryOperations;
import io.micronaut.data.operations.RepositoryOperations;
import io.micronaut.data.runtime.intercept.AbstractQueryInterceptor;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.data.jpa.domain.Specification;

@Internal
public class FindOneSpecificationInterceptor
extends AbstractQueryInterceptor<Object, Object> {
    private final JpaRepositoryOperations jpaOperations;

    protected FindOneSpecificationInterceptor(@NonNull RepositoryOperations operations) {
        super(operations);
        if (!(operations instanceof JpaRepositoryOperations)) {
            throw new IllegalStateException("Repository operations must be na instance of JpaRepositoryOperations");
        }
        this.jpaOperations = (JpaRepositoryOperations)operations;
    }

    public Object intercept(RepositoryMethodKey methodKey, MethodInvocationContext<Object, Object> context) {
        Object parameterValue = context.getParameterValues()[0];
        if (parameterValue instanceof Specification) {
            Specification specification = (Specification)parameterValue;
            EntityManager entityManager = this.jpaOperations.getCurrentEntityManager();
            CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
            CriteriaQuery query = criteriaBuilder.createQuery(this.getRequiredRootEntity(context));
            Root root = query.from(this.getRequiredRootEntity(context));
            Predicate predicate = specification.toPredicate(root, query, criteriaBuilder);
            query.where((Expression)predicate);
            query.select((Selection)root);
            TypedQuery typedQuery = entityManager.createQuery(query);
            try {
                Object result = typedQuery.getSingleResult();
                ReturnType rt = context.getReturnType();
                Class returnType = rt.getType();
                if (returnType.isInstance(result)) {
                    return result;
                }
                return ConversionService.SHARED.convertRequired(result, rt.asArgument());
            }
            catch (NoResultException e) {
                if (context.isNullable()) {
                    return null;
                }
                throw new EmptyResultDataAccessException(1);
            }
        }
        throw new IllegalArgumentException("Argument must be an instance of: " + Specification.class);
    }
}

